/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A resource that represents a group of redundant wires.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireGroup extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether the wires in the wire group are enabled. When false, the wires in the wire
   * group are disabled. When true and when there is simultaneously no wire-specific override of
   * `adminEnabled` to false, a given wire is enabled. Defaults to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean adminEnabled;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of the wire group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A map that contains the logical endpoints of the wire group. Specify key-value pairs for the
   * map as follows:        - Key: an RFC1035 user-specified label.    - Value: an Endpoint object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, WireGroupEndpoint> endpoints;

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Alwayscompute#wireGroups for wire groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Indicates whether there are wire changes yet to be processed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean reconciling;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Topology details for the wire group configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WireGroupTopology topology;

  /**
   * Properties for all wires in the wire group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WireProperties wireProperties;

  /**
   * The single/redundant wire(s) managed by the wire group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Wire> wires;

  static {
    // hack to force ProGuard to consider Wire used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Wire.class);
  }

  /**
   * Indicates whether the wires in the wire group are enabled. When false, the wires in the wire
   * group are disabled. When true and when there is simultaneously no wire-specific override of
   * `adminEnabled` to false, a given wire is enabled. Defaults to true.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAdminEnabled() {
    return adminEnabled;
  }

  /**
   * Indicates whether the wires in the wire group are enabled. When false, the wires in the wire
   * group are disabled. When true and when there is simultaneously no wire-specific override of
   * `adminEnabled` to false, a given wire is enabled. Defaults to true.
   * @param adminEnabled adminEnabled or {@code null} for none
   */
  public WireGroup setAdminEnabled(java.lang.Boolean adminEnabled) {
    this.adminEnabled = adminEnabled;
    return this;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public WireGroup setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of the wire group.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of the wire group.
   * @param description description or {@code null} for none
   */
  public WireGroup setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A map that contains the logical endpoints of the wire group. Specify key-value pairs for the
   * map as follows:        - Key: an RFC1035 user-specified label.    - Value: an Endpoint object.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, WireGroupEndpoint> getEndpoints() {
    return endpoints;
  }

  /**
   * A map that contains the logical endpoints of the wire group. Specify key-value pairs for the
   * map as follows:        - Key: an RFC1035 user-specified label.    - Value: an Endpoint object.
   * @param endpoints endpoints or {@code null} for none
   */
  public WireGroup setEndpoints(java.util.Map<String, WireGroupEndpoint> endpoints) {
    this.endpoints = endpoints;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public WireGroup setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Alwayscompute#wireGroups for wire groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Alwayscompute#wireGroups for wire groups.
   * @param kind kind or {@code null} for none
   */
  public WireGroup setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply withRFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public WireGroup setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Indicates whether there are wire changes yet to be processed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReconciling() {
    return reconciling;
  }

  /**
   * [Output Only] Indicates whether there are wire changes yet to be processed.
   * @param reconciling reconciling or {@code null} for none
   */
  public WireGroup setReconciling(java.lang.Boolean reconciling) {
    this.reconciling = reconciling;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public WireGroup setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Topology details for the wire group configuration.
   * @return value or {@code null} for none
   */
  public WireGroupTopology getTopology() {
    return topology;
  }

  /**
   * Topology details for the wire group configuration.
   * @param topology topology or {@code null} for none
   */
  public WireGroup setTopology(WireGroupTopology topology) {
    this.topology = topology;
    return this;
  }

  /**
   * Properties for all wires in the wire group.
   * @return value or {@code null} for none
   */
  public WireProperties getWireProperties() {
    return wireProperties;
  }

  /**
   * Properties for all wires in the wire group.
   * @param wireProperties wireProperties or {@code null} for none
   */
  public WireGroup setWireProperties(WireProperties wireProperties) {
    this.wireProperties = wireProperties;
    return this;
  }

  /**
   * The single/redundant wire(s) managed by the wire group.
   * @return value or {@code null} for none
   */
  public java.util.List<Wire> getWires() {
    return wires;
  }

  /**
   * The single/redundant wire(s) managed by the wire group.
   * @param wires wires or {@code null} for none
   */
  public WireGroup setWires(java.util.List<Wire> wires) {
    this.wires = wires;
    return this;
  }

  @Override
  public WireGroup set(String fieldName, Object value) {
    return (WireGroup) super.set(fieldName, value);
  }

  @Override
  public WireGroup clone() {
    return (WireGroup) super.clone();
  }

}
