/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The redundant Interconnect connections for this endpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireGroupEndpointInterconnect extends com.google.api.client.json.GenericJson {

  /**
   * Required. An Interconnect connection. You can specify the connection as a partial or full URL.
   * If the connection is in a different project from the cross-site network, use a format that
   * specifies the project. See the following examples of partial and full URLs:
   * global/interconnects/NAME                  projects/PROJECT_ID/global/interconnects/NAME
   * -        https://compute.googleapis.com/compute/projects/PROJECT_ID/global/interconnects/NAME
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String interconnect;

  /**
   * Required. To configure the wire group for VLAN mode, enter a VLAN tag, which is a number from
   * `2` to `4093`. You can autoallocate a tag by entering `0`. To configure the wire group for port
   * mode, enter `-1`. Review the following guidelines:        - A VLAN tag must be unique for an
   * Interconnect connection across all    attachments and wire groups.    - Both endpoints of a
   * wire must use the same VLAN tag value.    - Single wire and redundant type wire groups must
   * have only one    VLAN tag.    - Port mode pseudowires must have a single VLAN tag with a value
   * of    `-1` for both endpoints.    - Box and cross type wire groups must have two VLAN tags. The
   * first    is for the same-zone pseudowire, and the second is for the cross-zone    pseudowire.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.Integer> vlanTags;

  /**
   * Required. An Interconnect connection. You can specify the connection as a partial or full URL.
   * If the connection is in a different project from the cross-site network, use a format that
   * specifies the project. See the following examples of partial and full URLs:
   * global/interconnects/NAME                  projects/PROJECT_ID/global/interconnects/NAME
   * -        https://compute.googleapis.com/compute/projects/PROJECT_ID/global/interconnects/NAME
   * @return value or {@code null} for none
   */
  public java.lang.String getInterconnect() {
    return interconnect;
  }

  /**
   * Required. An Interconnect connection. You can specify the connection as a partial or full URL.
   * If the connection is in a different project from the cross-site network, use a format that
   * specifies the project. See the following examples of partial and full URLs:
   * global/interconnects/NAME                  projects/PROJECT_ID/global/interconnects/NAME
   * -        https://compute.googleapis.com/compute/projects/PROJECT_ID/global/interconnects/NAME
   * @param interconnect interconnect or {@code null} for none
   */
  public WireGroupEndpointInterconnect setInterconnect(java.lang.String interconnect) {
    this.interconnect = interconnect;
    return this;
  }

  /**
   * Required. To configure the wire group for VLAN mode, enter a VLAN tag, which is a number from
   * `2` to `4093`. You can autoallocate a tag by entering `0`. To configure the wire group for port
   * mode, enter `-1`. Review the following guidelines:        - A VLAN tag must be unique for an
   * Interconnect connection across all    attachments and wire groups.    - Both endpoints of a
   * wire must use the same VLAN tag value.    - Single wire and redundant type wire groups must
   * have only one    VLAN tag.    - Port mode pseudowires must have a single VLAN tag with a value
   * of    `-1` for both endpoints.    - Box and cross type wire groups must have two VLAN tags. The
   * first    is for the same-zone pseudowire, and the second is for the cross-zone    pseudowire.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Integer> getVlanTags() {
    return vlanTags;
  }

  /**
   * Required. To configure the wire group for VLAN mode, enter a VLAN tag, which is a number from
   * `2` to `4093`. You can autoallocate a tag by entering `0`. To configure the wire group for port
   * mode, enter `-1`. Review the following guidelines:        - A VLAN tag must be unique for an
   * Interconnect connection across all    attachments and wire groups.    - Both endpoints of a
   * wire must use the same VLAN tag value.    - Single wire and redundant type wire groups must
   * have only one    VLAN tag.    - Port mode pseudowires must have a single VLAN tag with a value
   * of    `-1` for both endpoints.    - Box and cross type wire groups must have two VLAN tags. The
   * first    is for the same-zone pseudowire, and the second is for the cross-zone    pseudowire.
   * @param vlanTags vlanTags or {@code null} for none
   */
  public WireGroupEndpointInterconnect setVlanTags(java.util.List<java.lang.Integer> vlanTags) {
    this.vlanTags = vlanTags;
    return this;
  }

  @Override
  public WireGroupEndpointInterconnect set(String fieldName, Object value) {
    return (WireGroupEndpointInterconnect) super.set(fieldName, value);
  }

  @Override
  public WireGroupEndpointInterconnect clone() {
    return (WireGroupEndpointInterconnect) super.clone();
  }

}
