/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-04-15 19:10:39 UTC)
 * on 2014-06-02 at 20:03:55 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstancesScopedList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstancesScopedList extends com.google.api.client.json.GenericJson {

  /**
   * List of instances contained in this scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Instance> instances;

  static {
    // hack to force ProGuard to consider Instance used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Instance.class);
  }

  /**
   * Informational warning which replaces the list of instances when the list is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Warning warning;

  /**
   * List of instances contained in this scope.
   * @return value or {@code null} for none
   */
  public java.util.List<Instance> getInstances() {
    return instances;
  }

  /**
   * List of instances contained in this scope.
   * @param instances instances or {@code null} for none
   */
  public InstancesScopedList setInstances(java.util.List<Instance> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * Informational warning which replaces the list of instances when the list is empty.
   * @return value or {@code null} for none
   */
  public Warning getWarning() {
    return warning;
  }

  /**
   * Informational warning which replaces the list of instances when the list is empty.
   * @param warning warning or {@code null} for none
   */
  public InstancesScopedList setWarning(Warning warning) {
    this.warning = warning;
    return this;
  }

  @Override
  public InstancesScopedList set(String fieldName, Object value) {
    return (InstancesScopedList) super.set(fieldName, value);
  }

  @Override
  public InstancesScopedList clone() {
    return (InstancesScopedList) super.clone();
  }

  /**
   * Informational warning which replaces the list of instances when the list is empty.
   */
  public static final class Warning extends com.google.api.client.json.GenericJson {

    /**
     * The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * Metadata for this warning in 'key: value' format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * The warning type identifier for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * The warning type identifier for this warning.
     * @param code code or {@code null} for none
     */
    public Warning setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @return value or {@code null} for none
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * Metadata for this warning in 'key: value' format.
     * @param data data or {@code null} for none
     */
    public Warning setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * Optional human-readable details for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * Optional human-readable details for this warning.
     * @param message message or {@code null} for none
     */
    public Warning setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Warning set(String fieldName, Object value) {
      return (Warning) super.set(fieldName, value);
    }

    @Override
    public Warning clone() {
      return (Warning) super.clone();
    }

    /**
     * Model definition for InstancesScopedListWarningData.
     */
    public static final class Data extends com.google.api.client.json.GenericJson {

      /**
       * A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String key;

      /**
       * A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String value;

      /**
       * A key for the warning data.
       * @return value or {@code null} for none
       */
      public java.lang.String getKey() {
        return key;
      }

      /**
       * A key for the warning data.
       * @param key key or {@code null} for none
       */
      public Data setKey(java.lang.String key) {
        this.key = key;
        return this;
      }

      /**
       * A warning data value corresponding to the key.
       * @return value or {@code null} for none
       */
      public java.lang.String getValue() {
        return value;
      }

      /**
       * A warning data value corresponding to the key.
       * @param value value or {@code null} for none
       */
      public Data setValue(java.lang.String value) {
        this.value = value;
        return this;
      }

      @Override
      public Data set(String fieldName, Object value) {
        return (Data) super.set(fieldName, value);
      }

      @Override
      public Data clone() {
        return (Data) super.clone();
      }

    }
  }
}
