/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A Duration represents a fixed-length span of time represented as a count of seconds and fractions
 * of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or
 * "month". Range is approximately 10,000 years.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Duration extends com.google.api.client.json.GenericJson {

  /**
   * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one
   * second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to
   * 999,999,999 inclusive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nanos;

  /**
   * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note:
   * these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000
   * years
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long seconds;

  /**
   * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one
   * second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to
   * 999,999,999 inclusive.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNanos() {
    return nanos;
  }

  /**
   * Span of time that's a fraction of a second at nanosecond resolution. Durations less than one
   * second are represented with a 0 `seconds` field and a positive `nanos` field. Must be from 0 to
   * 999,999,999 inclusive.
   * @param nanos nanos or {@code null} for none
   */
  public Duration setNanos(java.lang.Integer nanos) {
    this.nanos = nanos;
    return this;
  }

  /**
   * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note:
   * these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000
   * years
   * @return value or {@code null} for none
   */
  public java.lang.Long getSeconds() {
    return seconds;
  }

  /**
   * Span of time at a resolution of a second. Must be from 0 to 315,576,000,000 inclusive. Note:
   * these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000
   * years
   * @param seconds seconds or {@code null} for none
   */
  public Duration setSeconds(java.lang.Long seconds) {
    this.seconds = seconds;
    return this;
  }

  @Override
  public Duration set(String fieldName, Object value) {
    return (Duration) super.set(fieldName, value);
  }

  @Override
  public Duration clone() {
    return (Duration) super.clone();
  }

}
