/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ExchangedPeeringRoute.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExchangedPeeringRoute extends com.google.api.client.json.GenericJson {

  /**
   * The destination range of the route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destRange;

  /**
   * True if the peering route has been imported from a peer. The actual import happens if the field
   * networkPeering.importCustomRoutes is true for this network, and
   * networkPeering.exportCustomRoutes is true for the peer network, and the import does not result
   * in a route conflict.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean imported;

  /**
   * The region of peering route next hop, only applies to dynamic routes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextHopRegion;

  /**
   * The priority of the peering route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long priority;

  /**
   * The type of the peering route.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The destination range of the route.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestRange() {
    return destRange;
  }

  /**
   * The destination range of the route.
   * @param destRange destRange or {@code null} for none
   */
  public ExchangedPeeringRoute setDestRange(java.lang.String destRange) {
    this.destRange = destRange;
    return this;
  }

  /**
   * True if the peering route has been imported from a peer. The actual import happens if the field
   * networkPeering.importCustomRoutes is true for this network, and
   * networkPeering.exportCustomRoutes is true for the peer network, and the import does not result
   * in a route conflict.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getImported() {
    return imported;
  }

  /**
   * True if the peering route has been imported from a peer. The actual import happens if the field
   * networkPeering.importCustomRoutes is true for this network, and
   * networkPeering.exportCustomRoutes is true for the peer network, and the import does not result
   * in a route conflict.
   * @param imported imported or {@code null} for none
   */
  public ExchangedPeeringRoute setImported(java.lang.Boolean imported) {
    this.imported = imported;
    return this;
  }

  /**
   * The region of peering route next hop, only applies to dynamic routes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextHopRegion() {
    return nextHopRegion;
  }

  /**
   * The region of peering route next hop, only applies to dynamic routes.
   * @param nextHopRegion nextHopRegion or {@code null} for none
   */
  public ExchangedPeeringRoute setNextHopRegion(java.lang.String nextHopRegion) {
    this.nextHopRegion = nextHopRegion;
    return this;
  }

  /**
   * The priority of the peering route.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPriority() {
    return priority;
  }

  /**
   * The priority of the peering route.
   * @param priority priority or {@code null} for none
   */
  public ExchangedPeeringRoute setPriority(java.lang.Long priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The type of the peering route.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the peering route.
   * @param type type or {@code null} for none
   */
  public ExchangedPeeringRoute setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ExchangedPeeringRoute set(String fieldName, Object value) {
    return (ExchangedPeeringRoute) super.set(fieldName, value);
  }

  @Override
  public ExchangedPeeringRoute clone() {
    return (ExchangedPeeringRoute) super.clone();
  }

}
