/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The spec for modifying the path before sending the request to the matched backend service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlRewrite extends com.google.api.client.json.GenericJson {

  /**
   * Prior to forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite. The value must be between 1 and 255 characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostRewrite;

  /**
   * Prior to forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced by pathPrefixRewrite. The value must be between 1 and 1024
   * characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathPrefixRewrite;

  /**
   * Prior to forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite. The value must be between 1 and 255 characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getHostRewrite() {
    return hostRewrite;
  }

  /**
   * Prior to forwarding the request to the selected service, the request's host header is replaced
   * with contents of hostRewrite. The value must be between 1 and 255 characters.
   * @param hostRewrite hostRewrite or {@code null} for none
   */
  public UrlRewrite setHostRewrite(java.lang.String hostRewrite) {
    this.hostRewrite = hostRewrite;
    return this;
  }

  /**
   * Prior to forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced by pathPrefixRewrite. The value must be between 1 and 1024
   * characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathPrefixRewrite() {
    return pathPrefixRewrite;
  }

  /**
   * Prior to forwarding the request to the selected backend service, the matching portion of the
   * request's path is replaced by pathPrefixRewrite. The value must be between 1 and 1024
   * characters.
   * @param pathPrefixRewrite pathPrefixRewrite or {@code null} for none
   */
  public UrlRewrite setPathPrefixRewrite(java.lang.String pathPrefixRewrite) {
    this.pathPrefixRewrite = pathPrefixRewrite;
    return this;
  }

  @Override
  public UrlRewrite set(String fieldName, Object value) {
    return (UrlRewrite) super.set(fieldName, value);
  }

  @Override
  public UrlRewrite clone() {
    return (UrlRewrite) super.clone();
  }

}
