/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2020-02-21 at 23:43:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A VPN connection contains all VPN tunnels connected from this VpnGateway to the same peer
 * gateway. The peer gateway could either be a external VPN gateway or GCP VPN gateway.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VpnGatewayStatusVpnConnection extends com.google.api.client.json.GenericJson {

  /**
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection
   * are connected. This field is mutually exclusive with peer_gcp_gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peerExternalGateway;

  /**
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are
   * connected. This field is mutually exclusive with peer_gcp_gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peerGcpGateway;

  /**
   * HighAvailabilityRequirementState for the VPN connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VpnGatewayStatusHighAvailabilityRequirementState state;

  /**
   * List of VPN tunnels that are in this VPN connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<VpnGatewayStatusTunnel> tunnels;

  static {
    // hack to force ProGuard to consider VpnGatewayStatusTunnel used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(VpnGatewayStatusTunnel.class);
  }

  /**
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection
   * are connected. This field is mutually exclusive with peer_gcp_gateway.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeerExternalGateway() {
    return peerExternalGateway;
  }

  /**
   * URL reference to the peer external VPN gateways to which the VPN tunnels in this VPN connection
   * are connected. This field is mutually exclusive with peer_gcp_gateway.
   * @param peerExternalGateway peerExternalGateway or {@code null} for none
   */
  public VpnGatewayStatusVpnConnection setPeerExternalGateway(java.lang.String peerExternalGateway) {
    this.peerExternalGateway = peerExternalGateway;
    return this;
  }

  /**
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are
   * connected. This field is mutually exclusive with peer_gcp_gateway.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeerGcpGateway() {
    return peerGcpGateway;
  }

  /**
   * URL reference to the peer side VPN gateways to which the VPN tunnels in this VPN connection are
   * connected. This field is mutually exclusive with peer_gcp_gateway.
   * @param peerGcpGateway peerGcpGateway or {@code null} for none
   */
  public VpnGatewayStatusVpnConnection setPeerGcpGateway(java.lang.String peerGcpGateway) {
    this.peerGcpGateway = peerGcpGateway;
    return this;
  }

  /**
   * HighAvailabilityRequirementState for the VPN connection.
   * @return value or {@code null} for none
   */
  public VpnGatewayStatusHighAvailabilityRequirementState getState() {
    return state;
  }

  /**
   * HighAvailabilityRequirementState for the VPN connection.
   * @param state state or {@code null} for none
   */
  public VpnGatewayStatusVpnConnection setState(VpnGatewayStatusHighAvailabilityRequirementState state) {
    this.state = state;
    return this;
  }

  /**
   * List of VPN tunnels that are in this VPN connection.
   * @return value or {@code null} for none
   */
  public java.util.List<VpnGatewayStatusTunnel> getTunnels() {
    return tunnels;
  }

  /**
   * List of VPN tunnels that are in this VPN connection.
   * @param tunnels tunnels or {@code null} for none
   */
  public VpnGatewayStatusVpnConnection setTunnels(java.util.List<VpnGatewayStatusTunnel> tunnels) {
    this.tunnels = tunnels;
    return this;
  }

  @Override
  public VpnGatewayStatusVpnConnection set(String fieldName, Object value) {
    return (VpnGatewayStatusVpnConnection) super.set(fieldName, value);
  }

  @Override
  public VpnGatewayStatusVpnConnection clone() {
    return (VpnGatewayStatusVpnConnection) super.clone();
  }

}
