/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-09 16:41:44 UTC)
 * on 2014-07-02 at 14:53:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Deprecation status for a public resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeprecationStatus extends com.google.api.client.json.GenericJson {

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deleted;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deprecated;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String obsolete;

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replacement;

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeleted() {
    return deleted;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DELETED.
   * @param deleted deleted or {@code null} for none
   */
  public DeprecationStatus setDeleted(java.lang.String deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeprecated() {
    return deprecated;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to DEPRECATED.
   * @param deprecated deprecated or {@code null} for none
   */
  public DeprecationStatus setDeprecated(java.lang.String deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * @return value or {@code null} for none
   */
  public java.lang.String getObsolete() {
    return obsolete;
  }

  /**
   * An optional RFC3339 timestamp on or after which the deprecation state of this resource will be
   * changed to OBSOLETE.
   * @param obsolete obsolete or {@code null} for none
   */
  public DeprecationStatus setObsolete(java.lang.String obsolete) {
    this.obsolete = obsolete;
    return this;
  }

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplacement() {
    return replacement;
  }

  /**
   * A URL of the suggested replacement for the deprecated resource. The deprecated resource and its
   * replacement must be resources of the same kind.
   * @param replacement replacement or {@code null} for none
   */
  public DeprecationStatus setReplacement(java.lang.String replacement) {
    this.replacement = replacement;
    return this;
  }

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The deprecation state. Can be "DEPRECATED", "OBSOLETE", or "DELETED". Operations which create a
   * new resource using a "DEPRECATED" resource will return successfully, but with a warning
   * indicating the deprecated resource and recommending its replacement. New uses of "OBSOLETE" or
   * "DELETED" resources will result in an error.
   * @param state state or {@code null} for none
   */
  public DeprecationStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public DeprecationStatus set(String fieldName, Object value) {
    return (DeprecationStatus) super.set(fieldName, value);
  }

  @Override
  public DeprecationStatus clone() {
    return (DeprecationStatus) super.clone();
  }

}
