/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-06-09 16:41:44 UTC)
 * on 2014-07-02 at 14:53:47 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains a list of persistent disk snapshot resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotList extends com.google.api.client.json.GenericJson {

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The persistent snapshot resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Snapshot> items;

  /**
   * Type of resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token used to continue a truncated list request (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Server defined URL for this resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public SnapshotList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The persistent snapshot resources.
   * @return value or {@code null} for none
   */
  public java.util.List<Snapshot> getItems() {
    return items;
  }

  /**
   * The persistent snapshot resources.
   * @param items items or {@code null} for none
   */
  public SnapshotList setItems(java.util.List<Snapshot> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of resource.
   * @param kind kind or {@code null} for none
   */
  public SnapshotList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public SnapshotList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Server defined URL for this resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for this resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public SnapshotList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public SnapshotList set(String fieldName, Object value) {
    return (SnapshotList) super.set(fieldName, value);
  }

  @Override
  public SnapshotList clone() {
    return (SnapshotList) super.clone();
  }

}
