/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-09 17:08:39 UTC)
 * on 2014-07-15 at 01:12:26 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Scheduling options for an Instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Scheduling extends com.google.api.client.json.GenericJson {

  /**
   * Whether the Instance should be automatically restarted whenever it is terminated by Compute
   * Engine (not terminated by user).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean automaticRestart;

  /**
   * How the instance should behave when the host machine undergoes maintenance that may temporarily
   * impact instance performance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onHostMaintenance;

  /**
   * Whether the Instance should be automatically restarted whenever it is terminated by Compute
   * Engine (not terminated by user).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutomaticRestart() {
    return automaticRestart;
  }

  /**
   * Whether the Instance should be automatically restarted whenever it is terminated by Compute
   * Engine (not terminated by user).
   * @param automaticRestart automaticRestart or {@code null} for none
   */
  public Scheduling setAutomaticRestart(java.lang.Boolean automaticRestart) {
    this.automaticRestart = automaticRestart;
    return this;
  }

  /**
   * How the instance should behave when the host machine undergoes maintenance that may temporarily
   * impact instance performance.
   * @return value or {@code null} for none
   */
  public java.lang.String getOnHostMaintenance() {
    return onHostMaintenance;
  }

  /**
   * How the instance should behave when the host machine undergoes maintenance that may temporarily
   * impact instance performance.
   * @param onHostMaintenance onHostMaintenance or {@code null} for none
   */
  public Scheduling setOnHostMaintenance(java.lang.String onHostMaintenance) {
    this.onHostMaintenance = onHostMaintenance;
    return this;
  }

  @Override
  public Scheduling set(String fieldName, Object value) {
    return (Scheduling) super.set(fieldName, value);
  }

  @Override
  public Scheduling clone() {
    return (Scheduling) super.clone();
  }

}
