/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-07-26 at 01:08:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A machine type resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MachineType extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The deprecation status associated with this machine type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Count of CPUs exposed to the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer guestCpus;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Space allotted for the image, defined in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer imageSpaceGb;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Maximum persistent disks allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maximumPersistentDisks;

  /**
   * Maximum total persistent disks size (GB) allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maximumPersistentDisksSizeGb;

  /**
   * Physical memory assigned to the instance, defined in MB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer memoryMb;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * List of extended scratch disks assigned to the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ScratchDisks> scratchDisks;

  static {
    // hack to force ProGuard to consider ScratchDisks used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ScratchDisks.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Url of the zone where the machine type resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public MachineType setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this machine type.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this machine type.
   * @param deprecated deprecated or {@code null} for none
   */
  public MachineType setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * An optional textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource.
   * @param description description or {@code null} for none
   */
  public MachineType setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Count of CPUs exposed to the instance.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getGuestCpus() {
    return guestCpus;
  }

  /**
   * Count of CPUs exposed to the instance.
   * @param guestCpus guestCpus or {@code null} for none
   */
  public MachineType setGuestCpus(java.lang.Integer guestCpus) {
    this.guestCpus = guestCpus;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public MachineType setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Space allotted for the image, defined in GB.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getImageSpaceGb() {
    return imageSpaceGb;
  }

  /**
   * Space allotted for the image, defined in GB.
   * @param imageSpaceGb imageSpaceGb or {@code null} for none
   */
  public MachineType setImageSpaceGb(java.lang.Integer imageSpaceGb) {
    this.imageSpaceGb = imageSpaceGb;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public MachineType setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Maximum persistent disks allowed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaximumPersistentDisks() {
    return maximumPersistentDisks;
  }

  /**
   * Maximum persistent disks allowed.
   * @param maximumPersistentDisks maximumPersistentDisks or {@code null} for none
   */
  public MachineType setMaximumPersistentDisks(java.lang.Integer maximumPersistentDisks) {
    this.maximumPersistentDisks = maximumPersistentDisks;
    return this;
  }

  /**
   * Maximum total persistent disks size (GB) allowed.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaximumPersistentDisksSizeGb() {
    return maximumPersistentDisksSizeGb;
  }

  /**
   * Maximum total persistent disks size (GB) allowed.
   * @param maximumPersistentDisksSizeGb maximumPersistentDisksSizeGb or {@code null} for none
   */
  public MachineType setMaximumPersistentDisksSizeGb(java.lang.Long maximumPersistentDisksSizeGb) {
    this.maximumPersistentDisksSizeGb = maximumPersistentDisksSizeGb;
    return this;
  }

  /**
   * Physical memory assigned to the instance, defined in MB.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMemoryMb() {
    return memoryMb;
  }

  /**
   * Physical memory assigned to the instance, defined in MB.
   * @param memoryMb memoryMb or {@code null} for none
   */
  public MachineType setMemoryMb(java.lang.Integer memoryMb) {
    this.memoryMb = memoryMb;
    return this;
  }

  /**
   * Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * @param name name or {@code null} for none
   */
  public MachineType setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * List of extended scratch disks assigned to the instance.
   * @return value or {@code null} for none
   */
  public java.util.List<ScratchDisks> getScratchDisks() {
    return scratchDisks;
  }

  /**
   * List of extended scratch disks assigned to the instance.
   * @param scratchDisks scratchDisks or {@code null} for none
   */
  public MachineType setScratchDisks(java.util.List<ScratchDisks> scratchDisks) {
    this.scratchDisks = scratchDisks;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public MachineType setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Url of the zone where the machine type resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * Url of the zone where the machine type resides (output only).
   * @param zone zone or {@code null} for none
   */
  public MachineType setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public MachineType set(String fieldName, Object value) {
    return (MachineType) super.set(fieldName, value);
  }

  @Override
  public MachineType clone() {
    return (MachineType) super.clone();
  }

  /**
   * Model definition for MachineTypeScratchDisks.
   */
  public static final class ScratchDisks extends com.google.api.client.json.GenericJson {

    /**
     * Size of the scratch disk, defined in GB.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer diskGb;

    /**
     * Size of the scratch disk, defined in GB.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getDiskGb() {
      return diskGb;
    }

    /**
     * Size of the scratch disk, defined in GB.
     * @param diskGb diskGb or {@code null} for none
     */
    public ScratchDisks setDiskGb(java.lang.Integer diskGb) {
      this.diskGb = diskGb;
      return this;
    }

    @Override
    public ScratchDisks set(String fieldName, Object value) {
      return (ScratchDisks) super.set(fieldName, value);
    }

    @Override
    public ScratchDisks clone() {
      return (ScratchDisks) super.clone();
    }

  }

}
