/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-08-21 at 22:36:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Message containing information of one individual backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Backend extends com.google.api.client.json.GenericJson {

  /**
   * The balancing mode of this backend, default is UTILIZATION.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String balancingMode;

  /**
   * The multiplier (a value between 0 and 1e6) of the max capacity (CPU or RPS, depending on
   * 'balancingMode') the group should serve up to. 0 means the group is totally drained. Default
   * value is 1. Valid range is [0, 1e6].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float capacityScaler;

  /**
   * An optional textual description of the resource, which is provided by the client when the
   * resource is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * URL of a zonal Cloud Resource View resource. This resource view defines the list of instances
   * that serve traffic. Member virtual machine instances from each resource view must live in the
   * same zone as the resource view itself. No two backends in a backend service are allowed to use
   * same Resource View resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String group;

  /**
   * The max RPS of the group. Can be used with either balancing mode, but required if RATE mode.
   * For RATE mode, either maxRate or maxRatePerInstance must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxRate;

  /**
   * The max RPS that a single backed instance can handle. This is used to calculate the capacity of
   * the group. Can be used in either balancing mode. For RATE mode, either maxRate or
   * maxRatePerInstance must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxRatePerInstance;

  /**
   * Used when 'balancingMode' is UTILIZATION. This ratio defines the CPU utilization target for the
   * group. The default is 0.8. Valid range is [0, 1].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float maxUtilization;

  /**
   * The balancing mode of this backend, default is UTILIZATION.
   * @return value or {@code null} for none
   */
  public java.lang.String getBalancingMode() {
    return balancingMode;
  }

  /**
   * The balancing mode of this backend, default is UTILIZATION.
   * @param balancingMode balancingMode or {@code null} for none
   */
  public Backend setBalancingMode(java.lang.String balancingMode) {
    this.balancingMode = balancingMode;
    return this;
  }

  /**
   * The multiplier (a value between 0 and 1e6) of the max capacity (CPU or RPS, depending on
   * 'balancingMode') the group should serve up to. 0 means the group is totally drained. Default
   * value is 1. Valid range is [0, 1e6].
   * @return value or {@code null} for none
   */
  public java.lang.Float getCapacityScaler() {
    return capacityScaler;
  }

  /**
   * The multiplier (a value between 0 and 1e6) of the max capacity (CPU or RPS, depending on
   * 'balancingMode') the group should serve up to. 0 means the group is totally drained. Default
   * value is 1. Valid range is [0, 1e6].
   * @param capacityScaler capacityScaler or {@code null} for none
   */
  public Backend setCapacityScaler(java.lang.Float capacityScaler) {
    this.capacityScaler = capacityScaler;
    return this;
  }

  /**
   * An optional textual description of the resource, which is provided by the client when the
   * resource is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource, which is provided by the client when the
   * resource is created.
   * @param description description or {@code null} for none
   */
  public Backend setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * URL of a zonal Cloud Resource View resource. This resource view defines the list of instances
   * that serve traffic. Member virtual machine instances from each resource view must live in the
   * same zone as the resource view itself. No two backends in a backend service are allowed to use
   * same Resource View resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroup() {
    return group;
  }

  /**
   * URL of a zonal Cloud Resource View resource. This resource view defines the list of instances
   * that serve traffic. Member virtual machine instances from each resource view must live in the
   * same zone as the resource view itself. No two backends in a backend service are allowed to use
   * same Resource View resource.
   * @param group group or {@code null} for none
   */
  public Backend setGroup(java.lang.String group) {
    this.group = group;
    return this;
  }

  /**
   * The max RPS of the group. Can be used with either balancing mode, but required if RATE mode.
   * For RATE mode, either maxRate or maxRatePerInstance must be set.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxRate() {
    return maxRate;
  }

  /**
   * The max RPS of the group. Can be used with either balancing mode, but required if RATE mode.
   * For RATE mode, either maxRate or maxRatePerInstance must be set.
   * @param maxRate maxRate or {@code null} for none
   */
  public Backend setMaxRate(java.lang.Integer maxRate) {
    this.maxRate = maxRate;
    return this;
  }

  /**
   * The max RPS that a single backed instance can handle. This is used to calculate the capacity of
   * the group. Can be used in either balancing mode. For RATE mode, either maxRate or
   * maxRatePerInstance must be set.
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxRatePerInstance() {
    return maxRatePerInstance;
  }

  /**
   * The max RPS that a single backed instance can handle. This is used to calculate the capacity of
   * the group. Can be used in either balancing mode. For RATE mode, either maxRate or
   * maxRatePerInstance must be set.
   * @param maxRatePerInstance maxRatePerInstance or {@code null} for none
   */
  public Backend setMaxRatePerInstance(java.lang.Float maxRatePerInstance) {
    this.maxRatePerInstance = maxRatePerInstance;
    return this;
  }

  /**
   * Used when 'balancingMode' is UTILIZATION. This ratio defines the CPU utilization target for the
   * group. The default is 0.8. Valid range is [0, 1].
   * @return value or {@code null} for none
   */
  public java.lang.Float getMaxUtilization() {
    return maxUtilization;
  }

  /**
   * Used when 'balancingMode' is UTILIZATION. This ratio defines the CPU utilization target for the
   * group. The default is 0.8. Valid range is [0, 1].
   * @param maxUtilization maxUtilization or {@code null} for none
   */
  public Backend setMaxUtilization(java.lang.Float maxUtilization) {
    this.maxUtilization = maxUtilization;
    return this;
  }

  @Override
  public Backend set(String fieldName, Object value) {
    return (Backend) super.set(fieldName, value);
  }

  @Override
  public Backend clone() {
    return (Backend) super.clone();
  }

}
