/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-03 at 21:54:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A TargetPool resource. This resource defines a pool of VMs, associated HttpHealthCheck resources,
 * and the fallback TargetPool.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetPool extends com.google.api.client.json.GenericJson {

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool, and its 'failoverRatio' field is properly set to a value between [0, 1].
   *
   * 'backupPool' and 'failoverRatio' together define the fallback behavior of the primary target
   * pool: if the ratio of the healthy VMs in the primary pool is at or below 'failoverRatio',
   * traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' and 'backupPool' are not set, or all the VMs in the backup pool
   * are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where
   * traffic will be spread to the healthy VMs with the best effort, or to all VMs when no VM is
   * healthy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backupPool;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool (i.e., not as a backup pool to some other target pool). The value of the field
   * must be in [0, 1].
   *
   * If set, 'backupPool' must also be set. They together define the fallback behavior of the
   * primary target pool: if the ratio of the healthy VMs in the primary pool is at or below this
   * number, traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup pool are unhealthy, the
   * traffic will be directed back to the primary pool in the "force" mode, where traffic will be
   * spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float failoverRatio;

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> healthChecks;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> instances;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the region where the target pool resides (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Sesssion affinity option, must be one of the following values: 'NONE': Connections from the
   * same client IP may go to any VM in the pool; 'CLIENT_IP': Connections from the same client IP
   * will go to the same VM in the pool while that VM remains healthy. 'CLIENT_IP_PROTO':
   * Connections from the same client IP with the same IP protocol will go to the same VM in the
   * pool while that VM remains healthy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sessionAffinity;

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool, and its 'failoverRatio' field is properly set to a value between [0, 1].
   *
   * 'backupPool' and 'failoverRatio' together define the fallback behavior of the primary target
   * pool: if the ratio of the healthy VMs in the primary pool is at or below 'failoverRatio',
   * traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' and 'backupPool' are not set, or all the VMs in the backup pool
   * are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where
   * traffic will be spread to the healthy VMs with the best effort, or to all VMs when no VM is
   * healthy.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackupPool() {
    return backupPool;
  }

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool, and its 'failoverRatio' field is properly set to a value between [0, 1].
   *
   * 'backupPool' and 'failoverRatio' together define the fallback behavior of the primary target
   * pool: if the ratio of the healthy VMs in the primary pool is at or below 'failoverRatio',
   * traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' and 'backupPool' are not set, or all the VMs in the backup pool
   * are unhealthy, the traffic will be directed back to the primary pool in the "force" mode, where
   * traffic will be spread to the healthy VMs with the best effort, or to all VMs when no VM is
   * healthy.
   * @param backupPool backupPool or {@code null} for none
   */
  public TargetPool setBackupPool(java.lang.String backupPool) {
    this.backupPool = backupPool;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public TargetPool setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public TargetPool setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool (i.e., not as a backup pool to some other target pool). The value of the field
   * must be in [0, 1].
   *
   * If set, 'backupPool' must also be set. They together define the fallback behavior of the
   * primary target pool: if the ratio of the healthy VMs in the primary pool is at or below this
   * number, traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup pool are unhealthy, the
   * traffic will be directed back to the primary pool in the "force" mode, where traffic will be
   * spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   * @return value or {@code null} for none
   */
  public java.lang.Float getFailoverRatio() {
    return failoverRatio;
  }

  /**
   * This field is applicable only when the containing target pool is serving a forwarding rule as
   * the primary pool (i.e., not as a backup pool to some other target pool). The value of the field
   * must be in [0, 1].
   *
   * If set, 'backupPool' must also be set. They together define the fallback behavior of the
   * primary target pool: if the ratio of the healthy VMs in the primary pool is at or below this
   * number, traffic arriving at the load-balanced IP will be directed to the backup pool.
   *
   * In case where 'failoverRatio' is not set or all the VMs in the backup pool are unhealthy, the
   * traffic will be directed back to the primary pool in the "force" mode, where traffic will be
   * spread to the healthy VMs with the best effort, or to all VMs when no VM is healthy.
   * @param failoverRatio failoverRatio or {@code null} for none
   */
  public TargetPool setFailoverRatio(java.lang.Float failoverRatio) {
    this.failoverRatio = failoverRatio;
    return this;
  }

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHealthChecks() {
    return healthChecks;
  }

  /**
   * A list of URLs to the HttpHealthCheck resource. A member VM in this pool is considered healthy
   * if and only if all specified health checks pass. An empty list means all member VMs will be
   * considered healthy at all times.
   * @param healthChecks healthChecks or {@code null} for none
   */
  public TargetPool setHealthChecks(java.util.List<java.lang.String> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public TargetPool setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInstances() {
    return instances;
  }

  /**
   * A list of resource URLs to the member VMs serving this pool. They must live in zones contained
   * in the same region as this pool.
   * @param instances instances or {@code null} for none
   */
  public TargetPool setInstances(java.util.List<java.lang.String> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public TargetPool setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public TargetPool setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the region where the target pool resides (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * URL of the region where the target pool resides (output only).
   * @param region region or {@code null} for none
   */
  public TargetPool setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public TargetPool setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Sesssion affinity option, must be one of the following values: 'NONE': Connections from the
   * same client IP may go to any VM in the pool; 'CLIENT_IP': Connections from the same client IP
   * will go to the same VM in the pool while that VM remains healthy. 'CLIENT_IP_PROTO':
   * Connections from the same client IP with the same IP protocol will go to the same VM in the
   * pool while that VM remains healthy.
   * @return value or {@code null} for none
   */
  public java.lang.String getSessionAffinity() {
    return sessionAffinity;
  }

  /**
   * Sesssion affinity option, must be one of the following values: 'NONE': Connections from the
   * same client IP may go to any VM in the pool; 'CLIENT_IP': Connections from the same client IP
   * will go to the same VM in the pool while that VM remains healthy. 'CLIENT_IP_PROTO':
   * Connections from the same client IP with the same IP protocol will go to the same VM in the
   * pool while that VM remains healthy.
   * @param sessionAffinity sessionAffinity or {@code null} for none
   */
  public TargetPool setSessionAffinity(java.lang.String sessionAffinity) {
    this.sessionAffinity = sessionAffinity;
    return this;
  }

  @Override
  public TargetPool set(String fieldName, Object value) {
    return (TargetPool) super.set(fieldName, value);
  }

  @Override
  public TargetPool clone() {
    return (TargetPool) super.clone();
  }

}
