/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-09-03 at 21:54:09 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ForwardingRuleAggregatedList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForwardingRuleAggregatedList extends com.google.api.client.json.GenericJson {

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A map of scoped forwarding rule lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ForwardingRulesScopedList> items;

  static {
    // hack to force ProGuard to consider ForwardingRulesScopedList used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ForwardingRulesScopedList.class);
  }

  /**
   * Type of resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A token used to continue a truncated list request (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Server defined URL for this resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public ForwardingRuleAggregatedList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A map of scoped forwarding rule lists.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ForwardingRulesScopedList> getItems() {
    return items;
  }

  /**
   * A map of scoped forwarding rule lists.
   * @param items items or {@code null} for none
   */
  public ForwardingRuleAggregatedList setItems(java.util.Map<String, ForwardingRulesScopedList> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of resource.
   * @param kind kind or {@code null} for none
   */
  public ForwardingRuleAggregatedList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ForwardingRuleAggregatedList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Server defined URL for this resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for this resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public ForwardingRuleAggregatedList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public ForwardingRuleAggregatedList set(String fieldName, Object value) {
    return (ForwardingRuleAggregatedList) super.set(fieldName, value);
  }

  @Override
  public ForwardingRuleAggregatedList clone() {
    return (ForwardingRuleAggregatedList) super.clone();
  }

}
