/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-15 at 20:54:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A project resource. Projects can be created only in the APIs Console. Unless marked otherwise,
 * values can only be modified in the console.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Project extends com.google.api.client.json.GenericJson {

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata commonInstanceMetadata;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Quotas assigned to this project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Quota> quotas;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The location in Cloud Storage and naming method of the daily usage report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UsageExportLocation usageExportLocation;

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * @return value or {@code null} for none
   */
  public Metadata getCommonInstanceMetadata() {
    return commonInstanceMetadata;
  }

  /**
   * Metadata key/value pairs available to all instances contained in this project.
   * @param commonInstanceMetadata commonInstanceMetadata or {@code null} for none
   */
  public Project setCommonInstanceMetadata(Metadata commonInstanceMetadata) {
    this.commonInstanceMetadata = commonInstanceMetadata;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Project setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource.
   * @param description description or {@code null} for none
   */
  public Project setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Project setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Project setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * @param name name or {@code null} for none
   */
  public Project setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Quotas assigned to this project.
   * @return value or {@code null} for none
   */
  public java.util.List<Quota> getQuotas() {
    return quotas;
  }

  /**
   * Quotas assigned to this project.
   * @param quotas quotas or {@code null} for none
   */
  public Project setQuotas(java.util.List<Quota> quotas) {
    this.quotas = quotas;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Project setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The location in Cloud Storage and naming method of the daily usage report.
   * @return value or {@code null} for none
   */
  public UsageExportLocation getUsageExportLocation() {
    return usageExportLocation;
  }

  /**
   * The location in Cloud Storage and naming method of the daily usage report.
   * @param usageExportLocation usageExportLocation or {@code null} for none
   */
  public Project setUsageExportLocation(UsageExportLocation usageExportLocation) {
    this.usageExportLocation = usageExportLocation;
    return this;
  }

  @Override
  public Project set(String fieldName, Object value) {
    return (Project) super.set(fieldName, value);
  }

  @Override
  public Project clone() {
    return (Project) super.clone();
  }

}
