/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-22 21:53:01 UTC)
 * on 2014-10-21 at 00:17:08 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * Allows instances created based on this template to send packets with source IP addresses other
   * than their own and receive packets with destination IP addresses other than their own. If these
   * instances will be used as an IP gateway or it will be set as the next-hop in a Route resource,
   * say true. If unsure, leave this set to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * An optional textual description for the instances created based on the instance template
   * resource; provided by the client when the template is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Array of disks associated with instance created based on this template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  static {
    // hack to force ProGuard to consider AttachedDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AttachedDisk.class);
  }

  /**
   * Name of the machine type resource describing which machine type to use to host the instances
   * created based on this template; provided by the client when the instance template is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * Metadata key/value pairs assigned to instances created based on this template. Consists of
   * custom metadata or predefined keys; see Instance documentation for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instances created based based on this template will have no external internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  /**
   * Scheduling options for the instances created based on this template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instances created based on this template, through metadata queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  static {
    // hack to force ProGuard to consider ServiceAccount used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ServiceAccount.class);
  }

  /**
   * A list of tags to be applied to the instances created based on this template used to identify
   * valid sources or targets for network firewalls. Provided by the client on instance creation.
   * The tags can be later modified by the setTags method. Each tag within the list must comply with
   * RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * Allows instances created based on this template to send packets with source IP addresses other
   * than their own and receive packets with destination IP addresses other than their own. If these
   * instances will be used as an IP gateway or it will be set as the next-hop in a Route resource,
   * say true. If unsure, leave this set to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Allows instances created based on this template to send packets with source IP addresses other
   * than their own and receive packets with destination IP addresses other than their own. If these
   * instances will be used as an IP gateway or it will be set as the next-hop in a Route resource,
   * say true. If unsure, leave this set to false.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public InstanceProperties setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * An optional textual description for the instances created based on the instance template
   * resource; provided by the client when the template is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description for the instances created based on the instance template
   * resource; provided by the client when the template is created.
   * @param description description or {@code null} for none
   */
  public InstanceProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Array of disks associated with instance created based on this template.
   * @return value or {@code null} for none
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * Array of disks associated with instance created based on this template.
   * @param disks disks or {@code null} for none
   */
  public InstanceProperties setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Name of the machine type resource describing which machine type to use to host the instances
   * created based on this template; provided by the client when the instance template is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * Name of the machine type resource describing which machine type to use to host the instances
   * created based on this template; provided by the client when the instance template is created.
   * @param machineType machineType or {@code null} for none
   */
  public InstanceProperties setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * Metadata key/value pairs assigned to instances created based on this template. Consists of
   * custom metadata or predefined keys; see Instance documentation for more information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata key/value pairs assigned to instances created based on this template. Consists of
   * custom metadata or predefined keys; see Instance documentation for more information.
   * @param metadata metadata or {@code null} for none
   */
  public InstanceProperties setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instances created based based on this template will have no external internet access.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instances created based based on this template will have no external internet access.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public InstanceProperties setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * Scheduling options for the instances created based on this template.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * Scheduling options for the instances created based on this template.
   * @param scheduling scheduling or {@code null} for none
   */
  public InstanceProperties setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instances created based on this template, through metadata queries.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instances created based on this template, through metadata queries.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public InstanceProperties setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * A list of tags to be applied to the instances created based on this template used to identify
   * valid sources or targets for network firewalls. Provided by the client on instance creation.
   * The tags can be later modified by the setTags method. Each tag within the list must comply with
   * RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to be applied to the instances created based on this template used to identify
   * valid sources or targets for network firewalls. Provided by the client on instance creation.
   * The tags can be later modified by the setTags method. Each tag within the list must comply with
   * RFC1035.
   * @param tags tags or {@code null} for none
   */
  public InstanceProperties setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public InstanceProperties set(String fieldName, Object value) {
    return (InstanceProperties) super.set(fieldName, value);
  }

  @Override
  public InstanceProperties clone() {
    return (InstanceProperties) super.clone();
  }

}
