/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-01-14 17:53:03 UTC)
 * on 2015-02-04 at 22:38:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A host-matching rule for a URL. If matched, will use the named PathMatcher to select the
 * BackendService.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HostRule extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The list of host patterns to match. They must be valid hostnames except that they may start
   * with *. or *-. The * acts like a glob and will match any string of atoms (separated by .s and
   * -s) to the left.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> hosts;

  /**
   * The name of the PathMatcher to match the path portion of the URL, if the this HostRule matches
   * the URL's host portion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pathMatcher;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * @param description description or {@code null} for none
   */
  public HostRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The list of host patterns to match. They must be valid hostnames except that they may start
   * with *. or *-. The * acts like a glob and will match any string of atoms (separated by .s and
   * -s) to the left.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHosts() {
    return hosts;
  }

  /**
   * The list of host patterns to match. They must be valid hostnames except that they may start
   * with *. or *-. The * acts like a glob and will match any string of atoms (separated by .s and
   * -s) to the left.
   * @param hosts hosts or {@code null} for none
   */
  public HostRule setHosts(java.util.List<java.lang.String> hosts) {
    this.hosts = hosts;
    return this;
  }

  /**
   * The name of the PathMatcher to match the path portion of the URL, if the this HostRule matches
   * the URL's host portion.
   * @return value or {@code null} for none
   */
  public java.lang.String getPathMatcher() {
    return pathMatcher;
  }

  /**
   * The name of the PathMatcher to match the path portion of the URL, if the this HostRule matches
   * the URL's host portion.
   * @param pathMatcher pathMatcher or {@code null} for none
   */
  public HostRule setPathMatcher(java.lang.String pathMatcher) {
    this.pathMatcher = pathMatcher;
    return this;
  }

  @Override
  public HostRule set(String fieldName, Object value) {
    return (HostRule) super.set(fieldName, value);
  }

  @Override
  public HostRule clone() {
    return (HostRule) super.clone();
  }

}
