/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-01-14 17:53:03 UTC)
 * on 2015-02-04 at 22:38:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Region resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Region extends com.google.api.client.json.GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The deprecation status associated with this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Quotas assigned to this region.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Quota> quotas;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Status of the region, "UP" or "DOWN".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> zones;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Region setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this region.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this region.
   * @param deprecated deprecated or {@code null} for none
   */
  public Region setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource.
   * @param description description or {@code null} for none
   */
  public Region setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Region setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Region setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource.
   * @param name name or {@code null} for none
   */
  public Region setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Quotas assigned to this region.
   * @return value or {@code null} for none
   */
  public java.util.List<Quota> getQuotas() {
    return quotas;
  }

  /**
   * Quotas assigned to this region.
   * @param quotas quotas or {@code null} for none
   */
  public Region setQuotas(java.util.List<Quota> quotas) {
    this.quotas = quotas;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Region setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Status of the region, "UP" or "DOWN".
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the region, "UP" or "DOWN".
   * @param status status or {@code null} for none
   */
  public Region setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getZones() {
    return zones;
  }

  /**
   * A list of zones homed in this region, in the form of resource URLs.
   * @param zones zones or {@code null} for none
   */
  public Region setZones(java.util.List<java.lang.String> zones) {
    this.zones = zones;
    return this;
  }

  @Override
  public Region set(String fieldName, Object value) {
    return (Region) super.set(fieldName, value);
  }

  @Override
  public Region clone() {
    return (Region) super.clone();
  }

}
