/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-11-22 19:59:01 UTC)
 * on 2013-12-17 at 22:56:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A disk image resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Image extends com.google.api.client.json.GenericJson {

  /**
   * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long archiveSizeBytes;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * The deprecation status associated with this image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The raw disk image parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RawDisk rawDisk;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceType;

  /**
   * Status of the image (output only). It will be one of the following READY - after image has been
   * successfully created and is ready for use FAILED - if creating the image fails for some reason
   * PENDING - the image creation is in progress An image can be used to create other resources suck
   * as instances only after the image has been successfully created and the status is set to READY.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
   * @return value or {@code null} for none
   */
  public java.lang.Long getArchiveSizeBytes() {
    return archiveSizeBytes;
  }

  /**
   * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
   * @param archiveSizeBytes archiveSizeBytes or {@code null} for none
   */
  public Image setArchiveSizeBytes(java.lang.Long archiveSizeBytes) {
    this.archiveSizeBytes = archiveSizeBytes;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Image setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this image.
   * @return value or {@code null} for none
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this image.
   * @param deprecated deprecated or {@code null} for none
   */
  public Image setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * @param description description or {@code null} for none
   */
  public Image setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public Image setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public Image setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public Image setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The raw disk image parameters.
   * @return value or {@code null} for none
   */
  public RawDisk getRawDisk() {
    return rawDisk;
  }

  /**
   * The raw disk image parameters.
   * @param rawDisk rawDisk or {@code null} for none
   */
  public Image setRawDisk(RawDisk rawDisk) {
    this.rawDisk = rawDisk;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public Image setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceType() {
    return sourceType;
  }

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * @param sourceType sourceType or {@code null} for none
   */
  public Image setSourceType(java.lang.String sourceType) {
    this.sourceType = sourceType;
    return this;
  }

  /**
   * Status of the image (output only). It will be one of the following READY - after image has been
   * successfully created and is ready for use FAILED - if creating the image fails for some reason
   * PENDING - the image creation is in progress An image can be used to create other resources suck
   * as instances only after the image has been successfully created and the status is set to READY.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the image (output only). It will be one of the following READY - after image has been
   * successfully created and is ready for use FAILED - if creating the image fails for some reason
   * PENDING - the image creation is in progress An image can be used to create other resources suck
   * as instances only after the image has been successfully created and the status is set to READY.
   * @param status status or {@code null} for none
   */
  public Image setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public Image set(String fieldName, Object value) {
    return (Image) super.set(fieldName, value);
  }

  @Override
  public Image clone() {
    return (Image) super.clone();
  }

  /**
   * The raw disk image parameters.
   */
  public static final class RawDisk extends com.google.api.client.json.GenericJson {

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String containerType;

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String sha1Checksum;

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String source;

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * @return value or {@code null} for none
     */
    public java.lang.String getContainerType() {
      return containerType;
    }

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * @param containerType containerType or {@code null} for none
     */
    public RawDisk setContainerType(java.lang.String containerType) {
      this.containerType = containerType;
      return this;
    }

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * @return value or {@code null} for none
     */
    public java.lang.String getSha1Checksum() {
      return sha1Checksum;
    }

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * @param sha1Checksum sha1Checksum or {@code null} for none
     */
    public RawDisk setSha1Checksum(java.lang.String sha1Checksum) {
      this.sha1Checksum = sha1Checksum;
      return this;
    }

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * @return value or {@code null} for none
     */
    public java.lang.String getSource() {
      return source;
    }

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * @param source source or {@code null} for none
     */
    public RawDisk setSource(java.lang.String source) {
      this.source = source;
      return this;
    }

    @Override
    public RawDisk set(String fieldName, Object value) {
      return (RawDisk) super.set(fieldName, value);
    }

    @Override
    public RawDisk clone() {
      return (RawDisk) super.clone();
    }

  }

}
