/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-04-10 at 01:01:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A ForwardingRule resource. A ForwardingRule resource specifies which pool of target VMs to
 * forward a packet to if it matches the given [IPAddress, IPProtocol, portRange] tuple.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForwardingRule extends com.google.api.client.json.GenericJson {

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. For global
   * forwarding rules, the address must be a global IP; for regional forwarding rules, the address
   * must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP from the same scope (global or regional) will be assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPAddress")
  private java.lang.String iPAddress;

  /**
   * The IP protocol to which this rule applies, valid options are 'TCP', 'UDP', 'ESP', 'AH' or
   * 'SCTP'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPProtocol")
  private java.lang.String iPProtocol;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Applicable only when 'IPProtocol' is 'TCP', 'UDP' or 'SCTP', only packets addressed to ports in
   * the specified range will be forwarded to 'target'. If 'portRange' is left empty (default
   * value), all ports are forwarded. Forwarding rules with the same [IPAddress, IPProtocol] pair
   * must have disjoint port ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portRange;

  /**
   * URL of the region where the regional forwarding rule resides (output only). This field is not
   * applicable to global forwarding rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String target;

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. For global
   * forwarding rules, the address must be a global IP; for regional forwarding rules, the address
   * must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP from the same scope (global or regional) will be assigned.
   * @return value or {@code null} for none
   */
  public java.lang.String getIPAddress() {
    return iPAddress;
  }

  /**
   * Value of the reserved IP address that this forwarding rule is serving on behalf of. For global
   * forwarding rules, the address must be a global IP; for regional forwarding rules, the address
   * must live in the same region as the forwarding rule. If left empty (default value), an
   * ephemeral IP from the same scope (global or regional) will be assigned.
   * @param iPAddress iPAddress or {@code null} for none
   */
  public ForwardingRule setIPAddress(java.lang.String iPAddress) {
    this.iPAddress = iPAddress;
    return this;
  }

  /**
   * The IP protocol to which this rule applies, valid options are 'TCP', 'UDP', 'ESP', 'AH' or
   * 'SCTP'.
   * @return value or {@code null} for none
   */
  public java.lang.String getIPProtocol() {
    return iPProtocol;
  }

  /**
   * The IP protocol to which this rule applies, valid options are 'TCP', 'UDP', 'ESP', 'AH' or
   * 'SCTP'.
   * @param iPProtocol iPProtocol or {@code null} for none
   */
  public ForwardingRule setIPProtocol(java.lang.String iPProtocol) {
    this.iPProtocol = iPProtocol;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public ForwardingRule setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public ForwardingRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public ForwardingRule setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public ForwardingRule setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public ForwardingRule setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Applicable only when 'IPProtocol' is 'TCP', 'UDP' or 'SCTP', only packets addressed to ports in
   * the specified range will be forwarded to 'target'. If 'portRange' is left empty (default
   * value), all ports are forwarded. Forwarding rules with the same [IPAddress, IPProtocol] pair
   * must have disjoint port ranges.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortRange() {
    return portRange;
  }

  /**
   * Applicable only when 'IPProtocol' is 'TCP', 'UDP' or 'SCTP', only packets addressed to ports in
   * the specified range will be forwarded to 'target'. If 'portRange' is left empty (default
   * value), all ports are forwarded. Forwarding rules with the same [IPAddress, IPProtocol] pair
   * must have disjoint port ranges.
   * @param portRange portRange or {@code null} for none
   */
  public ForwardingRule setPortRange(java.lang.String portRange) {
    this.portRange = portRange;
    return this;
  }

  /**
   * URL of the region where the regional forwarding rule resides (output only). This field is not
   * applicable to global forwarding rules.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * URL of the region where the regional forwarding rule resides (output only). This field is not
   * applicable to global forwarding rules.
   * @param region region or {@code null} for none
   */
  public ForwardingRule setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public ForwardingRule setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getTarget() {
    return target;
  }

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy resource.
   * @param target target or {@code null} for none
   */
  public ForwardingRule setTarget(java.lang.String target) {
    this.target = target;
    return this;
  }

  @Override
  public ForwardingRule set(String fieldName, Object value) {
    return (ForwardingRule) super.set(fieldName, value);
  }

  @Override
  public ForwardingRule clone() {
    return (ForwardingRule) super.clone();
  }

}
