/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-04-17 at 23:36:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A Disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Disk extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Any applicable publicly visible licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> licenses;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Internal use only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String options;

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Size of the persistent disk, specified in GB. You can specify this field when creating a
   * persistent disk using the sourceImage or sourceSnapshot parameter, or specify it alone to
   * create an empty persistent disk.
   *
   * If you specify this field along with sourceImage or sourceSnapshot, the value of sizeGb must
   * not be less than the size of the sourceImage or the size of the snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sizeGb;

  /**
   * The source image used to create this disk. If the source image is deleted from the system, this
   * field will not be set, even if an image with the same name has been re-created.
   *
   * When creating a disk, you can provide a private (custom) image using the following input, and
   * Compute Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceImage;

  /**
   * The ID value of the image used to create this disk. This value identifies the exact image that
   * was used to create this persistent disk. For example, if you created the persistent disk from
   * an image that was later deleted and recreated under the same name, the source image ID would
   * identify the exact version of the image that was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceImageId;

  /**
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to
   * the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot  -
   * projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceSnapshot;

  /**
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the
   * exact snapshot that was used to create this persistent disk. For example, if you created the
   * persistent disk from a snapshot that was later deleted and recreated under the same name, the
   * source snapshot ID would identify the exact version of the snapshot that was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceSnapshotId;

  /**
   * [Output Only] The status of disk creation. Applicable statuses includes: CREATING, FAILED,
   * READY, RESTORING.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * URL of the disk type resource describing which disk type to use to create the disk; provided by
   * the client when the disk is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * [Output Only] URL of the zone where the disk resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Disk setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public Disk setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] Unique identifier for the resource; defined by the server.
   * @param id id or {@code null} for none
   */
  public Disk setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#disk for disks.
   * @param kind kind or {@code null} for none
   */
  public Disk setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Any applicable publicly visible licenses.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLicenses() {
    return licenses;
  }

  /**
   * Any applicable publicly visible licenses.
   * @param licenses licenses or {@code null} for none
   */
  public Disk setLicenses(java.util.List<java.lang.String> licenses) {
    this.licenses = licenses;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Disk setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Internal use only.
   * @return value or {@code null} for none
   */
  public java.lang.String getOptions() {
    return options;
  }

  /**
   * Internal use only.
   * @param options options or {@code null} for none
   */
  public Disk setOptions(java.lang.String options) {
    this.options = options;
    return this;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined fully-qualified URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Disk setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Size of the persistent disk, specified in GB. You can specify this field when creating a
   * persistent disk using the sourceImage or sourceSnapshot parameter, or specify it alone to
   * create an empty persistent disk.
   *
   * If you specify this field along with sourceImage or sourceSnapshot, the value of sizeGb must
   * not be less than the size of the sourceImage or the size of the snapshot.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSizeGb() {
    return sizeGb;
  }

  /**
   * Size of the persistent disk, specified in GB. You can specify this field when creating a
   * persistent disk using the sourceImage or sourceSnapshot parameter, or specify it alone to
   * create an empty persistent disk.
   *
   * If you specify this field along with sourceImage or sourceSnapshot, the value of sizeGb must
   * not be less than the size of the sourceImage or the size of the snapshot.
   * @param sizeGb sizeGb or {@code null} for none
   */
  public Disk setSizeGb(java.lang.Long sizeGb) {
    this.sizeGb = sizeGb;
    return this;
  }

  /**
   * The source image used to create this disk. If the source image is deleted from the system, this
   * field will not be set, even if an image with the same name has been re-created.
   *
   * When creating a disk, you can provide a private (custom) image using the following input, and
   * Compute Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceImage() {
    return sourceImage;
  }

  /**
   * The source image used to create this disk. If the source image is deleted from the system, this
   * field will not be set, even if an image with the same name has been re-created.
   *
   * When creating a disk, you can provide a private (custom) image using the following input, and
   * Compute Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * @param sourceImage sourceImage or {@code null} for none
   */
  public Disk setSourceImage(java.lang.String sourceImage) {
    this.sourceImage = sourceImage;
    return this;
  }

  /**
   * The ID value of the image used to create this disk. This value identifies the exact image that
   * was used to create this persistent disk. For example, if you created the persistent disk from
   * an image that was later deleted and recreated under the same name, the source image ID would
   * identify the exact version of the image that was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceImageId() {
    return sourceImageId;
  }

  /**
   * The ID value of the image used to create this disk. This value identifies the exact image that
   * was used to create this persistent disk. For example, if you created the persistent disk from
   * an image that was later deleted and recreated under the same name, the source image ID would
   * identify the exact version of the image that was used.
   * @param sourceImageId sourceImageId or {@code null} for none
   */
  public Disk setSourceImageId(java.lang.String sourceImageId) {
    this.sourceImageId = sourceImageId;
    return this;
  }

  /**
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to
   * the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot  -
   * projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceSnapshot() {
    return sourceSnapshot;
  }

  /**
   * The source snapshot used to create this disk. You can provide this as a partial or full URL to
   * the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot  -
   * projects/project/global/snapshots/snapshot  - global/snapshots/snapshot
   * @param sourceSnapshot sourceSnapshot or {@code null} for none
   */
  public Disk setSourceSnapshot(java.lang.String sourceSnapshot) {
    this.sourceSnapshot = sourceSnapshot;
    return this;
  }

  /**
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the
   * exact snapshot that was used to create this persistent disk. For example, if you created the
   * persistent disk from a snapshot that was later deleted and recreated under the same name, the
   * source snapshot ID would identify the exact version of the snapshot that was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceSnapshotId() {
    return sourceSnapshotId;
  }

  /**
   * [Output Only] The unique ID of the snapshot used to create this disk. This value identifies the
   * exact snapshot that was used to create this persistent disk. For example, if you created the
   * persistent disk from a snapshot that was later deleted and recreated under the same name, the
   * source snapshot ID would identify the exact version of the snapshot that was used.
   * @param sourceSnapshotId sourceSnapshotId or {@code null} for none
   */
  public Disk setSourceSnapshotId(java.lang.String sourceSnapshotId) {
    this.sourceSnapshotId = sourceSnapshotId;
    return this;
  }

  /**
   * [Output Only] The status of disk creation. Applicable statuses includes: CREATING, FAILED,
   * READY, RESTORING.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of disk creation. Applicable statuses includes: CREATING, FAILED,
   * READY, RESTORING.
   * @param status status or {@code null} for none
   */
  public Disk setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * URL of the disk type resource describing which disk type to use to create the disk; provided by
   * the client when the disk is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * URL of the disk type resource describing which disk type to use to create the disk; provided by
   * the client when the disk is created.
   * @param type type or {@code null} for none
   */
  public Disk setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * [Output Only] URL of the zone where the disk resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] URL of the zone where the disk resides.
   * @param zone zone or {@code null} for none
   */
  public Disk setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Disk set(String fieldName, Object value) {
    return (Disk) super.set(fieldName, value);
  }

  @Override
  public Disk clone() {
    return (Disk) super.clone();
  }

}
