/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-04-23 at 22:45:20 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for TargetInstancesScopedList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetInstancesScopedList extends com.google.api.client.json.GenericJson {

  /**
   * List of target instances contained in this scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TargetInstance> targetInstances;

  static {
    // hack to force ProGuard to consider TargetInstance used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(TargetInstance.class);
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Warning warning;

  /**
   * List of target instances contained in this scope.
   * @return value or {@code null} for none
   */
  public java.util.List<TargetInstance> getTargetInstances() {
    return targetInstances;
  }

  /**
   * List of target instances contained in this scope.
   * @param targetInstances targetInstances or {@code null} for none
   */
  public TargetInstancesScopedList setTargetInstances(java.util.List<TargetInstance> targetInstances) {
    this.targetInstances = targetInstances;
    return this;
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * @return value or {@code null} for none
   */
  public Warning getWarning() {
    return warning;
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   * @param warning warning or {@code null} for none
   */
  public TargetInstancesScopedList setWarning(Warning warning) {
    this.warning = warning;
    return this;
  }

  @Override
  public TargetInstancesScopedList set(String fieldName, Object value) {
    return (TargetInstancesScopedList) super.set(fieldName, value);
  }

  @Override
  public TargetInstancesScopedList clone() {
    return (TargetInstancesScopedList) super.clone();
  }

  /**
   * Informational warning which replaces the list of addresses when the list is empty.
   */
  public static final class Warning extends com.google.api.client.json.GenericJson {

    /**
     * [Output Only] The warning type identifier for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String code;

    /**
     * [Output Only] Metadata for this warning in key: value format.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<Data> data;

    static {
      // hack to force ProGuard to consider Data used, since otherwise it would be stripped out
      // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
      com.google.api.client.util.Data.nullOf(Data.class);
    }

    /**
     * [Output Only] Optional human-readable details for this warning.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String message;

    /**
     * [Output Only] The warning type identifier for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getCode() {
      return code;
    }

    /**
     * [Output Only] The warning type identifier for this warning.
     * @param code code or {@code null} for none
     */
    public Warning setCode(java.lang.String code) {
      this.code = code;
      return this;
    }

    /**
     * [Output Only] Metadata for this warning in key: value format.
     * @return value or {@code null} for none
     */
    public java.util.List<Data> getData() {
      return data;
    }

    /**
     * [Output Only] Metadata for this warning in key: value format.
     * @param data data or {@code null} for none
     */
    public Warning setData(java.util.List<Data> data) {
      this.data = data;
      return this;
    }

    /**
     * [Output Only] Optional human-readable details for this warning.
     * @return value or {@code null} for none
     */
    public java.lang.String getMessage() {
      return message;
    }

    /**
     * [Output Only] Optional human-readable details for this warning.
     * @param message message or {@code null} for none
     */
    public Warning setMessage(java.lang.String message) {
      this.message = message;
      return this;
    }

    @Override
    public Warning set(String fieldName, Object value) {
      return (Warning) super.set(fieldName, value);
    }

    @Override
    public Warning clone() {
      return (Warning) super.clone();
    }

    /**
     * Model definition for TargetInstancesScopedListWarningData.
     */
    public static final class Data extends com.google.api.client.json.GenericJson {

      /**
       * [Output Only] A key for the warning data.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String key;

      /**
       * [Output Only] A warning data value corresponding to the key.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.String value;

      /**
       * [Output Only] A key for the warning data.
       * @return value or {@code null} for none
       */
      public java.lang.String getKey() {
        return key;
      }

      /**
       * [Output Only] A key for the warning data.
       * @param key key or {@code null} for none
       */
      public Data setKey(java.lang.String key) {
        this.key = key;
        return this;
      }

      /**
       * [Output Only] A warning data value corresponding to the key.
       * @return value or {@code null} for none
       */
      public java.lang.String getValue() {
        return value;
      }

      /**
       * [Output Only] A warning data value corresponding to the key.
       * @param value value or {@code null} for none
       */
      public Data setValue(java.lang.String value) {
        this.value = value;
        return this;
      }

      @Override
      public Data set(String fieldName, Object value) {
        return (Data) super.set(fieldName, value);
      }

      @Override
      public Data clone() {
        return (Data) super.clone();
      }

    }
  }
}
