/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-05-05 20:00:12 UTC)
 * on 2015-05-11 at 20:02:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute;

/**
 * Service definition for Compute (v1).
 *
 * <p>
 * API for the Google Compute Engine service.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/compute/docs/reference/latest/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.19.0 of the Compute Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/v1/projects/";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Compute(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves the list of addresses grouped by scope.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of addresses grouped by scope.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of address resources contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of address resources contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendServices collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendServices.List request = compute.backendServices().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendServices backendServices() {
    return new BackendServices();
  }

  /**
   * The "backendServices" collection of methods.
   */
  public class BackendServices {

    /**
     * Deletes the specified BackendService resource.
     *
     * Create a request for the method "backendServices.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param backendService Name of the BackendService resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Delete result = new Delete(project, backendService);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified BackendService resource.
       *
       * Create a request for the method "backendServices.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param backendService Name of the BackendService resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to delete.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to delete. */
      public Delete setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendService resource.
     *
     * Create a request for the method "backendServices.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param backendService Name of the BackendService resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Get result = new Get(project, backendService);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendService> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified BackendService resource.
       *
       * Create a request for the method "backendServices.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param backendService Name of the BackendService resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendService.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to return.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to return. */
      public Get setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for this BackendService.
     *
     * Create a request for the method "backendServices.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param backendService Name of the BackendService resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, backendService, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.BackendServiceGroupHealth> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for this BackendService.
       *
       * Create a request for the method "backendServices.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param backendService Name of the BackendService resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.BackendServiceGroupHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the queried instance belongs.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      public GetHealth setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendService resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "backendServices.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendService resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "backendServices.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendService resources available to the specified project.
     *
     * Create a request for the method "backendServices.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendServiceList> {

      private static final String REST_PATH = "{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendService resources available to the specified project.
       *
       * Create a request for the method "backendServices.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Update the entire content of the BackendService resource. This method supports patch semantics.
     *
     * Create a request for the method "backendServices.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Patch result = new Patch(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Update the entire content of the BackendService resource. This method supports patch semantics.
       *
       * Create a request for the method "backendServices.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Patch setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Update the entire content of the BackendService resource.
     *
     * Create a request for the method "backendServices.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Update result = new Update(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Update the entire content of the BackendService resource.
       *
       * Create a request for the method "backendServices.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Update setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DiskTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.DiskTypes.List request = compute.diskTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DiskTypes diskTypes() {
    return new DiskTypes();
  }

  /**
   * The "diskTypes" collection of methods.
   */
  public class DiskTypes {

    /**
     * Retrieves the list of disk type resources grouped by scope.
     *
     * Create a request for the method "diskTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of disk type resources grouped by scope.
       *
       * Create a request for the method "diskTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified disk type resource.
     *
     * Create a request for the method "diskTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param diskType Name of the disk type resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String diskType) throws java.io.IOException {
      Get result = new Get(project, zone, diskType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.DiskType> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes/{diskType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified disk type resource.
       *
       * Create a request for the method "diskTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param diskType Name of the disk type resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String diskType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = com.google.api.client.util.Preconditions.checkNotNull(diskType, "Required parameter diskType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the disk type resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String diskType;

      /** Name of the disk type resource to return.
       */
      public java.lang.String getDiskType() {
        return diskType;
      }

      /** Name of the disk type resource to return. */
      public Get setDiskType(java.lang.String diskType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = diskType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of disk type resources available to the specified project.
     *
     * Create a request for the method "diskTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of disk type resources available to the specified project.
       *
       * Create a request for the method "diskTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Retrieves the list of disks grouped by scope.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of disks grouped by scope.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Creates a snapshot of this disk.
     *
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to snapshot.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a snapshot of this disk.
       *
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to snapshot.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public CreateSnapshot setAlt(java.lang.String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setFields(java.lang.String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(java.lang.String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(java.lang.String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(java.lang.String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUserIp(java.lang.String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public CreateSnapshot setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public CreateSnapshot setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to snapshot.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to snapshot. */
      public CreateSnapshot setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public CreateSnapshot set(String parameterName, Object value) {
        return (CreateSnapshot) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified persistent disk.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to delete. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to delete.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to delete. */
      public Delete setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns a specified persistent disk.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns a specified persistent disk.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to return. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to return.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to return. */
      public Get setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a persistent disk in the specified project using the data included in the request.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk in the specified project using the data included in the request.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Optional. Source image to restore onto a disk. */
      @com.google.api.client.util.Key
      private java.lang.String sourceImage;

      /** Optional. Source image to restore onto a disk.
       */
      public java.lang.String getSourceImage() {
        return sourceImage;
      }

      /** Optional. Source image to restore onto a disk. */
      public Insert setSourceImage(java.lang.String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of persistent disks contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of persistent disks contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall resource.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified firewall resource.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to delete.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to delete. */
      public Delete setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall resource.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified firewall resource.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to return.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to return. */
      public Get setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a firewall resource in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall resource in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of firewall resources available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall resources available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall resource with the data included in the request. This method
     * supports patch semantics.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request. This method
       * supports patch semantics.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Patch setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall resource with the data included in the request.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall resource to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates the specified firewall resource with the data included in the request.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall resource to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall resource to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall resource to update. */
      public Update setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves the list of forwarding rules grouped by scope.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of forwarding rules grouped by scope.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target url for forwarding rule.
     *
     * Create a request for the method "forwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, region, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target url for forwarding rule.
       *
       * Create a request for the method "forwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetTarget setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalAddresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalAddresses.List request = compute.globalAddresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalAddresses globalAddresses() {
    return new GlobalAddresses();
  }

  /**
   * The "globalAddresses" collection of methods.
   */
  public class GlobalAddresses {

    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "globalAddresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "globalAddresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "globalAddresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "{project}/global/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "globalAddresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project using the data included in the request.
     *
     * Create a request for the method "globalAddresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an address resource in the specified project using the data included in the request.
       *
       * Create a request for the method "globalAddresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of global address resources.
     *
     * Create a request for the method "globalAddresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "{project}/global/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of global address resources.
       *
       * Create a request for the method "globalAddresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalForwardingRules.List request = compute.globalForwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalForwardingRules globalForwardingRules() {
    return new GlobalForwardingRules();
  }

  /**
   * The "globalForwardingRules" collection of methods.
   */
  public class GlobalForwardingRules {

    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "globalForwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "globalForwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "globalForwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "globalForwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "globalForwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "globalForwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of ForwardingRule resources available to the specified project.
     *
     * Create a request for the method "globalForwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "{project}/global/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of ForwardingRule resources available to the specified project.
       *
       * Create a request for the method "globalForwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes target url for forwarding rule.
     *
     * Create a request for the method "globalForwardingRules.setTarget".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetTarget setTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetTarget result = new SetTarget(project, forwardingRule, content);
      initialize(result);
      return result;
    }

    public class SetTarget extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/forwardingRules/{forwardingRule}/setTarget";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes target url for forwarding rule.
       *
       * Create a request for the method "globalForwardingRules.setTarget".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTarget#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTarget#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource in which target is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetTarget(java.lang.String project, java.lang.String forwardingRule, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTarget setAlt(java.lang.String alt) {
        return (SetTarget) super.setAlt(alt);
      }

      @Override
      public SetTarget setFields(java.lang.String fields) {
        return (SetTarget) super.setFields(fields);
      }

      @Override
      public SetTarget setKey(java.lang.String key) {
        return (SetTarget) super.setKey(key);
      }

      @Override
      public SetTarget setOauthToken(java.lang.String oauthToken) {
        return (SetTarget) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTarget setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTarget) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTarget setQuotaUser(java.lang.String quotaUser) {
        return (SetTarget) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTarget setUserIp(java.lang.String userIp) {
        return (SetTarget) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetTarget setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource in which target is to be set.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource in which target is to be set. */
      public SetTarget setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public SetTarget set(String parameterName, Object value) {
        return (SetTarget) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GlobalOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.GlobalOperations.List request = compute.globalOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GlobalOperations globalOperations() {
    return new GlobalOperations();
  }

  /**
   * The "globalOperations" collection of methods.
   */
  public class GlobalOperations {

    /**
     * Retrieves the list of all operations grouped by scope.
     *
     * Create a request for the method "globalOperations.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.OperationAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of all operations grouped by scope.
       *
       * Create a request for the method "globalOperations.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified operation resource.
     *
     * Create a request for the method "globalOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified operation resource.
       *
       * Create a request for the method "globalOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified operation resource.
     *
     * Create a request for the method "globalOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified operation resource.
       *
       * Create a request for the method "globalOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified project.
     *
     * Create a request for the method "globalOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/global/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of operation resources contained within the specified project.
       *
       * Create a request for the method "globalOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the HttpHealthChecks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.HttpHealthChecks.List request = compute.httpHealthChecks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public HttpHealthChecks httpHealthChecks() {
    return new HttpHealthChecks();
  }

  /**
   * The "httpHealthChecks" collection of methods.
   */
  public class HttpHealthChecks {

    /**
     * Deletes the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Delete result = new Delete(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to delete.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to delete. */
      public Delete setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified HttpHealthCheck resource.
     *
     * Create a request for the method "httpHealthChecks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String httpHealthCheck) throws java.io.IOException {
      Get result = new Get(project, httpHealthCheck);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheck> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified HttpHealthCheck resource.
       *
       * Create a request for the method "httpHealthChecks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String httpHealthCheck) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheck.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to return.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to return. */
      public Get setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of HttpHealthCheck resources available to the specified project.
     *
     * Create a request for the method "httpHealthChecks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.HttpHealthCheckList> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of HttpHealthCheck resources available to the specified project.
       *
       * Create a request for the method "httpHealthChecks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.HttpHealthCheckList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request. This method supports patch semantics.
     *
     * Create a request for the method "httpHealthChecks.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Patch result = new Patch(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request. This method supports patch semantics.
       *
       * Create a request for the method "httpHealthChecks.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Patch setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a HttpHealthCheck resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "httpHealthChecks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
     * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) throws java.io.IOException {
      Update result = new Update(project, httpHealthCheck, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/httpHealthChecks/{httpHealthCheck}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern HTTP_HEALTH_CHECK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Updates a HttpHealthCheck resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "httpHealthChecks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param httpHealthCheck Name of the HttpHealthCheck resource to update.
       * @param content the {@link com.google.api.services.compute.model.HttpHealthCheck}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String httpHealthCheck, com.google.api.services.compute.model.HttpHealthCheck content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.httpHealthCheck = com.google.api.client.util.Preconditions.checkNotNull(httpHealthCheck, "Required parameter httpHealthCheck must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the HttpHealthCheck resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String httpHealthCheck;

      /** Name of the HttpHealthCheck resource to update.
       */
      public java.lang.String getHttpHealthCheck() {
        return httpHealthCheck;
      }

      /** Name of the HttpHealthCheck resource to update. */
      public Update setHttpHealthCheck(java.lang.String httpHealthCheck) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(HTTP_HEALTH_CHECK_PATTERN.matcher(httpHealthCheck).matches(),
              "Parameter httpHealthCheck must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.httpHealthCheck = httpHealthCheck;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Images collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Images.List request = compute.images().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Images images() {
    return new Images();
  }

  /**
   * The "images" collection of methods.
   */
  public class Images {

    /**
     * Deletes the specified image resource.
     *
     * Create a request for the method "images.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Delete result = new Delete(project, image);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified image resource.
       *
       * Create a request for the method "images.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String image) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to delete.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to delete. */
      public Delete setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Sets the deprecation status of an image.
     *
     * If an empty request body is given, clears the deprecation status instead.
     *
     * Create a request for the method "images.deprecate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Image name.
     * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
     * @return the request
     */
    public Deprecate deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) throws java.io.IOException {
      Deprecate result = new Deprecate(project, image, content);
      initialize(result);
      return result;
    }

    public class Deprecate extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images/{image}/deprecate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets the deprecation status of an image.
       *
       * If an empty request body is given, clears the deprecation status instead.
       *
       * Create a request for the method "images.deprecate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Deprecate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Deprecate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Image name.
       * @param content the {@link com.google.api.services.compute.model.DeprecationStatus}
       * @since 1.13
       */
      protected Deprecate(java.lang.String project, java.lang.String image, com.google.api.services.compute.model.DeprecationStatus content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Deprecate setAlt(java.lang.String alt) {
        return (Deprecate) super.setAlt(alt);
      }

      @Override
      public Deprecate setFields(java.lang.String fields) {
        return (Deprecate) super.setFields(fields);
      }

      @Override
      public Deprecate setKey(java.lang.String key) {
        return (Deprecate) super.setKey(key);
      }

      @Override
      public Deprecate setOauthToken(java.lang.String oauthToken) {
        return (Deprecate) super.setOauthToken(oauthToken);
      }

      @Override
      public Deprecate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Deprecate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Deprecate setQuotaUser(java.lang.String quotaUser) {
        return (Deprecate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Deprecate setUserIp(java.lang.String userIp) {
        return (Deprecate) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Deprecate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Image name. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Image name.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Image name. */
      public Deprecate setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Deprecate set(String parameterName, Object value) {
        return (Deprecate) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified image resource.
     *
     * Create a request for the method "images.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param image Name of the image resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String image) throws java.io.IOException {
      Get result = new Get(project, image);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Image> {

      private static final String REST_PATH = "{project}/global/images/{image}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern IMAGE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified image resource.
       *
       * Create a request for the method "images.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param image Name of the image resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String image) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Image.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.image = com.google.api.client.util.Preconditions.checkNotNull(image, "Required parameter image must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the image resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String image;

      /** Name of the image resource to return.
       */
      public java.lang.String getImage() {
        return image;
      }

      /** Name of the image resource to return. */
      public Get setImage(java.lang.String image) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(IMAGE_PATTERN.matcher(image).matches(),
              "Parameter image must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.image = image;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an image resource in the specified project using the data included in the request.
     *
     * Create a request for the method "images.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Image}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Image content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an image resource in the specified project using the data included in the request.
       *
       * Create a request for the method "images.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Image}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Image content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of image resources available to the specified project.
     *
     * Create a request for the method "images.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ImageList> {

      private static final String REST_PATH = "{project}/global/images";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of image resources available to the specified project.
       *
       * Create a request for the method "images.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ImageList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the InstanceTemplates collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.InstanceTemplates.List request = compute.instanceTemplates().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public InstanceTemplates instanceTemplates() {
    return new InstanceTemplates();
  }

  /**
   * The "instanceTemplates" collection of methods.
   */
  public class InstanceTemplates {

    /**
     * Deletes the specified instance template.
     *
     * Create a request for the method "instanceTemplates.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project The project ID for this request.
     * @param instanceTemplate The name of the instance template to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String instanceTemplate) throws java.io.IOException {
      Delete result = new Delete(project, instanceTemplate);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern INSTANCE_TEMPLATE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified instance template.
       *
       * Create a request for the method "instanceTemplates.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project The project ID for this request.
       * @param instanceTemplate The name of the instance template to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String instanceTemplate) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.instanceTemplate = com.google.api.client.util.Preconditions.checkNotNull(instanceTemplate, "Required parameter instanceTemplate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** The project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** The project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the instance template to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instanceTemplate;

      /** The name of the instance template to delete.
       */
      public java.lang.String getInstanceTemplate() {
        return instanceTemplate;
      }

      /** The name of the instance template to delete. */
      public Delete setInstanceTemplate(java.lang.String instanceTemplate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instanceTemplate = instanceTemplate;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance template resource.
     *
     * Create a request for the method "instanceTemplates.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project The project ID for this request.
     * @param instanceTemplate The name of the instance template.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String instanceTemplate) throws java.io.IOException {
      Get result = new Get(project, instanceTemplate);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.InstanceTemplate> {

      private static final String REST_PATH = "{project}/global/instanceTemplates/{instanceTemplate}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern INSTANCE_TEMPLATE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance template resource.
       *
       * Create a request for the method "instanceTemplates.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project The project ID for this request.
       * @param instanceTemplate The name of the instance template.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String instanceTemplate) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceTemplate.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.instanceTemplate = com.google.api.client.util.Preconditions.checkNotNull(instanceTemplate, "Required parameter instanceTemplate must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** The project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** The project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the instance template. */
      @com.google.api.client.util.Key
      private java.lang.String instanceTemplate;

      /** The name of the instance template.
       */
      public java.lang.String getInstanceTemplate() {
        return instanceTemplate;
      }

      /** The name of the instance template. */
      public Get setInstanceTemplate(java.lang.String instanceTemplate) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_TEMPLATE_PATTERN.matcher(instanceTemplate).matches(),
              "Parameter instanceTemplate must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instanceTemplate = instanceTemplate;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance template in the specified project using the data that is included in the
     * request.
     *
     * Create a request for the method "instanceTemplates.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project The project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.InstanceTemplate}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.InstanceTemplate content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/instanceTemplates";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates an instance template in the specified project using the data that is included in the
       * request.
       *
       * Create a request for the method "instanceTemplates.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project The project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.InstanceTemplate}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.InstanceTemplate content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** The project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** The project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of instance templates that are contained within the specified project and zone.
     *
     * Create a request for the method "instanceTemplates.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project The project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceTemplateList> {

      private static final String REST_PATH = "{project}/global/instanceTemplates";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves a list of instance templates that are contained within the specified project and
       * zone.
       *
       * Create a request for the method "instanceTemplates.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project The project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceTemplateList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** The project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** The project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Instances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Instances.List request = compute.instances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Instances instances() {
    return new Instances();
  }

  /**
   * The "instances" collection of methods.
   */
  public class Instances {

    /**
     * Adds an access config to an instance's network interface.
     *
     * Create a request for the method "instances.addAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name for this request.
     * @param networkInterface The name of the network interface to add to this instance.
     * @param content the {@link com.google.api.services.compute.model.AccessConfig}
     * @return the request
     */
    public AddAccessConfig addAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) throws java.io.IOException {
      AddAccessConfig result = new AddAccessConfig(project, zone, instance, networkInterface, content);
      initialize(result);
      return result;
    }

    public class AddAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/addAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds an access config to an instance's network interface.
       *
       * Create a request for the method "instances.addAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddAccessConfig#execute()} method to invoke the remote operation.
       * <p> {@link AddAccessConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name for this request.
       * @param networkInterface The name of the network interface to add to this instance.
       * @param content the {@link com.google.api.services.compute.model.AccessConfig}
       * @since 1.13
       */
      protected AddAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String networkInterface, com.google.api.services.compute.model.AccessConfig content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public AddAccessConfig setAlt(java.lang.String alt) {
        return (AddAccessConfig) super.setAlt(alt);
      }

      @Override
      public AddAccessConfig setFields(java.lang.String fields) {
        return (AddAccessConfig) super.setFields(fields);
      }

      @Override
      public AddAccessConfig setKey(java.lang.String key) {
        return (AddAccessConfig) super.setKey(key);
      }

      @Override
      public AddAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (AddAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public AddAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (AddAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddAccessConfig setUserIp(java.lang.String userIp) {
        return (AddAccessConfig) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public AddAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name for this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name for this request. */
      public AddAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** The name of the network interface to add to this instance. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** The name of the network interface to add to this instance.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** The name of the network interface to add to this instance. */
      public AddAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public AddAccessConfig set(String parameterName, Object value) {
        return (AddAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Create a request for the method "instances.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.InstanceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Create a request for the method "instances.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Attaches a Disk resource to an instance.
     *
     * Create a request for the method "instances.attachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
     * @return the request
     */
    public AttachDisk attachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) throws java.io.IOException {
      AttachDisk result = new AttachDisk(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class AttachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/attachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Attaches a Disk resource to an instance.
       *
       * Create a request for the method "instances.attachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AttachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * AttachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.AttachedDisk}
       * @since 1.13
       */
      protected AttachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.AttachedDisk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AttachDisk setAlt(java.lang.String alt) {
        return (AttachDisk) super.setAlt(alt);
      }

      @Override
      public AttachDisk setFields(java.lang.String fields) {
        return (AttachDisk) super.setFields(fields);
      }

      @Override
      public AttachDisk setKey(java.lang.String key) {
        return (AttachDisk) super.setKey(key);
      }

      @Override
      public AttachDisk setOauthToken(java.lang.String oauthToken) {
        return (AttachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public AttachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AttachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AttachDisk setQuotaUser(java.lang.String quotaUser) {
        return (AttachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public AttachDisk setUserIp(java.lang.String userIp) {
        return (AttachDisk) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AttachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public AttachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public AttachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public AttachDisk set(String parameterName, Object value) {
        return (AttachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified Instance resource. For more information, see Shutting down an instance.
     *
     * Create a request for the method "instances.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Delete result = new Delete(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified Instance resource. For more information, see Shutting down an instance.
       *
       * Create a request for the method "instances.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to delete.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to delete. */
      public Delete setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an access config from an instance's network interface.
     *
     * Create a request for the method "instances.deleteAccessConfig".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name for this request.
     * @param accessConfig The name of the access config to delete.
     * @param networkInterface The name of the network interface.
     * @return the request
     */
    public DeleteAccessConfig deleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) throws java.io.IOException {
      DeleteAccessConfig result = new DeleteAccessConfig(project, zone, instance, accessConfig, networkInterface);
      initialize(result);
      return result;
    }

    public class DeleteAccessConfig extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/deleteAccessConfig";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes an access config from an instance's network interface.
       *
       * Create a request for the method "instances.deleteAccessConfig".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteAccessConfig#execute()} method to invoke the remote
       * operation. <p> {@link DeleteAccessConfig#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name for this request.
       * @param accessConfig The name of the access config to delete.
       * @param networkInterface The name of the network interface.
       * @since 1.13
       */
      protected DeleteAccessConfig(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String accessConfig, java.lang.String networkInterface) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.accessConfig = com.google.api.client.util.Preconditions.checkNotNull(accessConfig, "Required parameter accessConfig must be specified.");
        this.networkInterface = com.google.api.client.util.Preconditions.checkNotNull(networkInterface, "Required parameter networkInterface must be specified.");
      }

      @Override
      public DeleteAccessConfig setAlt(java.lang.String alt) {
        return (DeleteAccessConfig) super.setAlt(alt);
      }

      @Override
      public DeleteAccessConfig setFields(java.lang.String fields) {
        return (DeleteAccessConfig) super.setFields(fields);
      }

      @Override
      public DeleteAccessConfig setKey(java.lang.String key) {
        return (DeleteAccessConfig) super.setKey(key);
      }

      @Override
      public DeleteAccessConfig setOauthToken(java.lang.String oauthToken) {
        return (DeleteAccessConfig) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteAccessConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteAccessConfig) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteAccessConfig setQuotaUser(java.lang.String quotaUser) {
        return (DeleteAccessConfig) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteAccessConfig setUserIp(java.lang.String userIp) {
        return (DeleteAccessConfig) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteAccessConfig setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public DeleteAccessConfig setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name for this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name for this request. */
      public DeleteAccessConfig setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** The name of the access config to delete. */
      @com.google.api.client.util.Key
      private java.lang.String accessConfig;

      /** The name of the access config to delete.
       */
      public java.lang.String getAccessConfig() {
        return accessConfig;
      }

      /** The name of the access config to delete. */
      public DeleteAccessConfig setAccessConfig(java.lang.String accessConfig) {
        this.accessConfig = accessConfig;
        return this;
      }

      /** The name of the network interface. */
      @com.google.api.client.util.Key
      private java.lang.String networkInterface;

      /** The name of the network interface.
       */
      public java.lang.String getNetworkInterface() {
        return networkInterface;
      }

      /** The name of the network interface. */
      public DeleteAccessConfig setNetworkInterface(java.lang.String networkInterface) {
        this.networkInterface = networkInterface;
        return this;
      }

      @Override
      public DeleteAccessConfig set(String parameterName, Object value) {
        return (DeleteAccessConfig) super.set(parameterName, value);
      }
    }
    /**
     * Detaches a disk from an instance.
     *
     * Create a request for the method "instances.detachDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Instance name.
     * @param deviceName Disk device name to detach.
     * @return the request
     */
    public DetachDisk detachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) throws java.io.IOException {
      DetachDisk result = new DetachDisk(project, zone, instance, deviceName);
      initialize(result);
      return result;
    }

    public class DetachDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/detachDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICE_NAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Detaches a disk from an instance.
       *
       * Create a request for the method "instances.detachDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DetachDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * DetachDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Instance name.
       * @param deviceName Disk device name to detach.
       * @since 1.13
       */
      protected DetachDisk(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.deviceName = com.google.api.client.util.Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public DetachDisk setAlt(java.lang.String alt) {
        return (DetachDisk) super.setAlt(alt);
      }

      @Override
      public DetachDisk setFields(java.lang.String fields) {
        return (DetachDisk) super.setFields(fields);
      }

      @Override
      public DetachDisk setKey(java.lang.String key) {
        return (DetachDisk) super.setKey(key);
      }

      @Override
      public DetachDisk setOauthToken(java.lang.String oauthToken) {
        return (DetachDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public DetachDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DetachDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DetachDisk setQuotaUser(java.lang.String quotaUser) {
        return (DetachDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public DetachDisk setUserIp(java.lang.String userIp) {
        return (DetachDisk) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DetachDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public DetachDisk setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public DetachDisk setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Disk device name to detach. */
      @com.google.api.client.util.Key
      private java.lang.String deviceName;

      /** Disk device name to detach.
       */
      public java.lang.String getDeviceName() {
        return deviceName;
      }

      /** Disk device name to detach. */
      public DetachDisk setDeviceName(java.lang.String deviceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

      @Override
      public DetachDisk set(String parameterName, Object value) {
        return (DetachDisk) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance resource.
     *
     * Create a request for the method "instances.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the The name of the zone for this request..
     * @param instance Name of the instance resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Get result = new Get(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Instance> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance resource.
       *
       * Create a request for the method "instances.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the The name of the zone for this request..
       * @param instance Name of the instance resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Instance.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the The name of the zone for this request.. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the The name of the zone for this request..
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the The name of the zone for this request.. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to return.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to return. */
      public Get setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified instance's serial port output.
     *
     * Create a request for the method "instances.getSerialPortOutput".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public GetSerialPortOutput getSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      GetSerialPortOutput result = new GetSerialPortOutput(project, zone, instance);
      initialize(result);
      return result;
    }

    public class GetSerialPortOutput extends ComputeRequest<com.google.api.services.compute.model.SerialPortOutput> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/serialPort";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified instance's serial port output.
       *
       * Create a request for the method "instances.getSerialPortOutput".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetSerialPortOutput#execute()} method to invoke the remote
       * operation. <p> {@link GetSerialPortOutput#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected GetSerialPortOutput(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SerialPortOutput.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetSerialPortOutput setAlt(java.lang.String alt) {
        return (GetSerialPortOutput) super.setAlt(alt);
      }

      @Override
      public GetSerialPortOutput setFields(java.lang.String fields) {
        return (GetSerialPortOutput) super.setFields(fields);
      }

      @Override
      public GetSerialPortOutput setKey(java.lang.String key) {
        return (GetSerialPortOutput) super.setKey(key);
      }

      @Override
      public GetSerialPortOutput setOauthToken(java.lang.String oauthToken) {
        return (GetSerialPortOutput) super.setOauthToken(oauthToken);
      }

      @Override
      public GetSerialPortOutput setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetSerialPortOutput) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetSerialPortOutput setQuotaUser(java.lang.String quotaUser) {
        return (GetSerialPortOutput) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetSerialPortOutput setUserIp(java.lang.String userIp) {
        return (GetSerialPortOutput) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetSerialPortOutput setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public GetSerialPortOutput setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public GetSerialPortOutput setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Which COM port to retrieve data from. */
      @com.google.api.client.util.Key
      private java.lang.Integer port;

      /** Which COM port to retrieve data from. [default: 1] [minimum: 1] [maximum: 4]
       */
      public java.lang.Integer getPort() {
        return port;
      }

      /** Which COM port to retrieve data from. */
      public GetSerialPortOutput setPort(java.lang.Integer port) {
        this.port = port;
        return this;
      }

      @Override
      public GetSerialPortOutput set(String parameterName, Object value) {
        return (GetSerialPortOutput) super.set(parameterName, value);
      }
    }
    /**
     * Creates an instance resource in the specified project using the data included in the request.
     *
     * Create a request for the method "instances.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Instance}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an instance resource in the specified project using the data included in the request.
       *
       * Create a request for the method "instances.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Instance}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Instance content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of instance resources contained within the specified zone.
     *
     * Create a request for the method "instances.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.InstanceList> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of instance resources contained within the specified zone.
       *
       * Create a request for the method "instances.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.InstanceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Performs a hard reset on the instance.
     *
     * Create a request for the method "instances.reset".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @return the request
     */
    public Reset reset(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Reset result = new Reset(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Reset extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/reset";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Performs a hard reset on the instance.
       *
       * Create a request for the method "instances.reset".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Reset#execute()} method to invoke the remote operation. <p> {@link
       * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @since 1.13
       */
      protected Reset(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Reset setAlt(java.lang.String alt) {
        return (Reset) super.setAlt(alt);
      }

      @Override
      public Reset setFields(java.lang.String fields) {
        return (Reset) super.setFields(fields);
      }

      @Override
      public Reset setKey(java.lang.String key) {
        return (Reset) super.setKey(key);
      }

      @Override
      public Reset setOauthToken(java.lang.String oauthToken) {
        return (Reset) super.setOauthToken(oauthToken);
      }

      @Override
      public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Reset) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Reset setQuotaUser(java.lang.String quotaUser) {
        return (Reset) super.setQuotaUser(quotaUser);
      }

      @Override
      public Reset setUserIp(java.lang.String userIp) {
        return (Reset) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Reset setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Reset setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public Reset setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Reset set(String parameterName, Object value) {
        return (Reset) super.set(parameterName, value);
      }
    }
    /**
     * Sets the auto-delete flag for a disk attached to an instance.
     *
     * Create a request for the method "instances.setDiskAutoDelete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetDiskAutoDelete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance The instance name.
     * @param autoDelete Whether to auto-delete the disk when the instance is deleted.
     * @param deviceName The device name of the disk to modify.
     * @return the request
     */
    public SetDiskAutoDelete setDiskAutoDelete(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.Boolean autoDelete, java.lang.String deviceName) throws java.io.IOException {
      SetDiskAutoDelete result = new SetDiskAutoDelete(project, zone, instance, autoDelete, deviceName);
      initialize(result);
      return result;
    }

    public class SetDiskAutoDelete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setDiskAutoDelete";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DEVICE_NAME_PATTERN =
          java.util.regex.Pattern.compile("\\w[\\w.-]{0,254}");

      /**
       * Sets the auto-delete flag for a disk attached to an instance.
       *
       * Create a request for the method "instances.setDiskAutoDelete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetDiskAutoDelete#execute()} method to invoke the remote operation.
       * <p> {@link SetDiskAutoDelete#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance The instance name.
       * @param autoDelete Whether to auto-delete the disk when the instance is deleted.
       * @param deviceName The device name of the disk to modify.
       * @since 1.13
       */
      protected SetDiskAutoDelete(java.lang.String project, java.lang.String zone, java.lang.String instance, java.lang.Boolean autoDelete, java.lang.String deviceName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoDelete = com.google.api.client.util.Preconditions.checkNotNull(autoDelete, "Required parameter autoDelete must be specified.");
        this.deviceName = com.google.api.client.util.Preconditions.checkNotNull(deviceName, "Required parameter deviceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
      }

      @Override
      public SetDiskAutoDelete setAlt(java.lang.String alt) {
        return (SetDiskAutoDelete) super.setAlt(alt);
      }

      @Override
      public SetDiskAutoDelete setFields(java.lang.String fields) {
        return (SetDiskAutoDelete) super.setFields(fields);
      }

      @Override
      public SetDiskAutoDelete setKey(java.lang.String key) {
        return (SetDiskAutoDelete) super.setKey(key);
      }

      @Override
      public SetDiskAutoDelete setOauthToken(java.lang.String oauthToken) {
        return (SetDiskAutoDelete) super.setOauthToken(oauthToken);
      }

      @Override
      public SetDiskAutoDelete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetDiskAutoDelete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetDiskAutoDelete setQuotaUser(java.lang.String quotaUser) {
        return (SetDiskAutoDelete) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetDiskAutoDelete setUserIp(java.lang.String userIp) {
        return (SetDiskAutoDelete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetDiskAutoDelete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetDiskAutoDelete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** The instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** The instance name. */
      public SetDiskAutoDelete setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      /** Whether to auto-delete the disk when the instance is deleted. */
      @com.google.api.client.util.Key
      private java.lang.Boolean autoDelete;

      /** Whether to auto-delete the disk when the instance is deleted.
       */
      public java.lang.Boolean getAutoDelete() {
        return autoDelete;
      }

      /** Whether to auto-delete the disk when the instance is deleted. */
      public SetDiskAutoDelete setAutoDelete(java.lang.Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
      }

      /** The device name of the disk to modify. */
      @com.google.api.client.util.Key
      private java.lang.String deviceName;

      /** The device name of the disk to modify.
       */
      public java.lang.String getDeviceName() {
        return deviceName;
      }

      /** The device name of the disk to modify. */
      public SetDiskAutoDelete setDeviceName(java.lang.String deviceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DEVICE_NAME_PATTERN.matcher(deviceName).matches(),
              "Parameter deviceName must conform to the pattern " +
              "\\w[\\w.-]{0,254}");
        }
        this.deviceName = deviceName;
        return this;
      }

      @Override
      public SetDiskAutoDelete set(String parameterName, Object value) {
        return (SetDiskAutoDelete) super.set(parameterName, value);
      }
    }
    /**
     * Sets metadata for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setMetadata".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetMetadata setMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetMetadata result = new SetMetadata(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets metadata for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetMetadata#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetMetadata#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetMetadata(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetMetadata setAlt(java.lang.String alt) {
        return (SetMetadata) super.setAlt(alt);
      }

      @Override
      public SetMetadata setFields(java.lang.String fields) {
        return (SetMetadata) super.setFields(fields);
      }

      @Override
      public SetMetadata setKey(java.lang.String key) {
        return (SetMetadata) super.setKey(key);
      }

      @Override
      public SetMetadata setOauthToken(java.lang.String oauthToken) {
        return (SetMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetMetadata setQuotaUser(java.lang.String quotaUser) {
        return (SetMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetMetadata setUserIp(java.lang.String userIp) {
        return (SetMetadata) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetMetadata setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetMetadata setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetMetadata setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetMetadata set(String parameterName, Object value) {
        return (SetMetadata) super.set(parameterName, value);
      }
    }
    /**
     * Sets an instance's scheduling options.
     *
     * Create a request for the method "instances.setScheduling".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Instance name.
     * @param content the {@link com.google.api.services.compute.model.Scheduling}
     * @return the request
     */
    public SetScheduling setScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) throws java.io.IOException {
      SetScheduling result = new SetScheduling(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetScheduling extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setScheduling";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets an instance's scheduling options.
       *
       * Create a request for the method "instances.setScheduling".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetScheduling#execute()} method to invoke the remote operation. <p>
       * {@link SetScheduling#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Instance name.
       * @param content the {@link com.google.api.services.compute.model.Scheduling}
       * @since 1.13
       */
      protected SetScheduling(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Scheduling content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetScheduling setAlt(java.lang.String alt) {
        return (SetScheduling) super.setAlt(alt);
      }

      @Override
      public SetScheduling setFields(java.lang.String fields) {
        return (SetScheduling) super.setFields(fields);
      }

      @Override
      public SetScheduling setKey(java.lang.String key) {
        return (SetScheduling) super.setKey(key);
      }

      @Override
      public SetScheduling setOauthToken(java.lang.String oauthToken) {
        return (SetScheduling) super.setOauthToken(oauthToken);
      }

      @Override
      public SetScheduling setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetScheduling) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetScheduling setQuotaUser(java.lang.String quotaUser) {
        return (SetScheduling) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetScheduling setUserIp(java.lang.String userIp) {
        return (SetScheduling) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetScheduling setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetScheduling setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Instance name. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Instance name.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Instance name. */
      public SetScheduling setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetScheduling set(String parameterName, Object value) {
        return (SetScheduling) super.set(parameterName, value);
      }
    }
    /**
     * Sets tags for the specified instance to the data included in the request.
     *
     * Create a request for the method "instances.setTags".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetTags#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Tags}
     * @return the request
     */
    public SetTags setTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) throws java.io.IOException {
      SetTags result = new SetTags(project, zone, instance, content);
      initialize(result);
      return result;
    }

    public class SetTags extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/setTags";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Sets tags for the specified instance to the data included in the request.
       *
       * Create a request for the method "instances.setTags".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetTags#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetTags#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Tags}
       * @since 1.13
       */
      protected SetTags(java.lang.String project, java.lang.String zone, java.lang.String instance, com.google.api.services.compute.model.Tags content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetTags setAlt(java.lang.String alt) {
        return (SetTags) super.setAlt(alt);
      }

      @Override
      public SetTags setFields(java.lang.String fields) {
        return (SetTags) super.setFields(fields);
      }

      @Override
      public SetTags setKey(java.lang.String key) {
        return (SetTags) super.setKey(key);
      }

      @Override
      public SetTags setOauthToken(java.lang.String oauthToken) {
        return (SetTags) super.setOauthToken(oauthToken);
      }

      @Override
      public SetTags setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetTags) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetTags setQuotaUser(java.lang.String quotaUser) {
        return (SetTags) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetTags setUserIp(java.lang.String userIp) {
        return (SetTags) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetTags setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetTags setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance scoping this request.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance scoping this request. */
      public SetTags setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public SetTags set(String parameterName, Object value) {
        return (SetTags) super.set(parameterName, value);
      }
    }
    /**
     * This method starts an instance that was stopped using the using the instances().stop method. For
     * more information, see Restart an instance.
     *
     * Create a request for the method "instances.start".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Start#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to start.
     * @return the request
     */
    public Start start(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Start result = new Start(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Start extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/start";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * This method starts an instance that was stopped using the using the instances().stop method.
       * For more information, see Restart an instance.
       *
       * Create a request for the method "instances.start".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Start#execute()} method to invoke the remote operation. <p> {@link
       * Start#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to start.
       * @since 1.13
       */
      protected Start(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Start setAlt(java.lang.String alt) {
        return (Start) super.setAlt(alt);
      }

      @Override
      public Start setFields(java.lang.String fields) {
        return (Start) super.setFields(fields);
      }

      @Override
      public Start setKey(java.lang.String key) {
        return (Start) super.setKey(key);
      }

      @Override
      public Start setOauthToken(java.lang.String oauthToken) {
        return (Start) super.setOauthToken(oauthToken);
      }

      @Override
      public Start setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Start) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Start setQuotaUser(java.lang.String quotaUser) {
        return (Start) super.setQuotaUser(quotaUser);
      }

      @Override
      public Start setUserIp(java.lang.String userIp) {
        return (Start) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Start setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Start setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to start. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to start.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to start. */
      public Start setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Start set(String parameterName, Object value) {
        return (Start) super.set(parameterName, value);
      }
    }
    /**
     * This method stops a running instance, shutting it down cleanly, and allows you to restart the
     * instance at a later time. Stopped instances do not incur per-minute, virtual machine usage
     * charges while they are stopped, but any resources that the virtual machine is using, such as
     * persistent disks and static IP addresses,will continue to be charged until they are deleted. For
     * more information, see Stopping an instance.
     *
     * Create a request for the method "instances.stop".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param instance Name of the instance resource to start.
     * @return the request
     */
    public Stop stop(java.lang.String project, java.lang.String zone, java.lang.String instance) throws java.io.IOException {
      Stop result = new Stop(project, zone, instance);
      initialize(result);
      return result;
    }

    public class Stop extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/instances/{instance}/stop";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * This method stops a running instance, shutting it down cleanly, and allows you to restart the
       * instance at a later time. Stopped instances do not incur per-minute, virtual machine usage
       * charges while they are stopped, but any resources that the virtual machine is using, such as
       * persistent disks and static IP addresses,will continue to be charged until they are deleted.
       * For more information, see Stopping an instance.
       *
       * Create a request for the method "instances.stop".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param instance Name of the instance resource to start.
       * @since 1.13
       */
      protected Stop(java.lang.String project, java.lang.String zone, java.lang.String instance) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = com.google.api.client.util.Preconditions.checkNotNull(instance, "Required parameter instance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Stop setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Stop setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the instance resource to start. */
      @com.google.api.client.util.Key
      private java.lang.String instance;

      /** Name of the instance resource to start.
       */
      public java.lang.String getInstance() {
        return instance;
      }

      /** Name of the instance resource to start. */
      public Stop setInstance(java.lang.String instance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(INSTANCE_PATTERN.matcher(instance).matches(),
              "Parameter instance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.instance = instance;
        return this;
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Licenses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Licenses.List request = compute.licenses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Licenses licenses() {
    return new Licenses();
  }

  /**
   * The "licenses" collection of methods.
   */
  public class Licenses {

    /**
     * Returns the specified license resource.
     *
     * Create a request for the method "licenses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param license Name of the license resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String license) throws java.io.IOException {
      Get result = new Get(project, license);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.License> {

      private static final String REST_PATH = "{project}/global/licenses/{license}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern LICENSE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified license resource.
       *
       * Create a request for the method "licenses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param license Name of the license resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String license) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.License.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.license = com.google.api.client.util.Preconditions.checkNotNull(license, "Required parameter license must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(LICENSE_PATTERN.matcher(license).matches(),
              "Parameter license must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the license resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String license;

      /** Name of the license resource to return.
       */
      public java.lang.String getLicense() {
        return license;
      }

      /** Name of the license resource to return. */
      public Get setLicense(java.lang.String license) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(LICENSE_PATTERN.matcher(license).matches(),
              "Parameter license must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.license = license;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the MachineTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.MachineTypes.List request = compute.machineTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public MachineTypes machineTypes() {
    return new MachineTypes();
  }

  /**
   * The "machineTypes" collection of methods.
   */
  public class MachineTypes {

    /**
     * Retrieves the list of machine type resources grouped by scope.
     *
     * Create a request for the method "machineTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.MachineTypeAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of machine type resources grouped by scope.
       *
       * Create a request for the method "machineTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified machine type resource.
     *
     * Create a request for the method "machineTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param machineType Name of the machine type resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String machineType) throws java.io.IOException {
      Get result = new Get(project, zone, machineType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.MachineType> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes/{machineType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern MACHINE_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified machine type resource.
       *
       * Create a request for the method "machineTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param machineType Name of the machine type resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String machineType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = com.google.api.client.util.Preconditions.checkNotNull(machineType, "Required parameter machineType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINE_TYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the machine type resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String machineType;

      /** Name of the machine type resource to return.
       */
      public java.lang.String getMachineType() {
        return machineType;
      }

      /** Name of the machine type resource to return. */
      public Get setMachineType(java.lang.String machineType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MACHINE_TYPE_PATTERN.matcher(machineType).matches(),
              "Parameter machineType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.machineType = machineType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of machine type resources available to the specified project.
     *
     * Create a request for the method "machineTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.MachineTypeList> {

      private static final String REST_PATH = "{project}/zones/{zone}/machineTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of machine type resources available to the specified project.
       *
       * Create a request for the method "machineTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.MachineTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Networks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Networks.List request = compute.networks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Networks networks() {
    return new Networks();
  }

  /**
   * The "networks" collection of methods.
   */
  public class Networks {

    /**
     * Deletes the specified network resource.
     *
     * Create a request for the method "networks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param network Name of the network resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Delete result = new Delete(project, network);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified network resource.
       *
       * Create a request for the method "networks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param network Name of the network resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String network) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network resource to delete.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network resource to delete. */
      public Delete setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified network resource.
     *
     * Create a request for the method "networks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param network Name of the network resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String network) throws java.io.IOException {
      Get result = new Get(project, network);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Network> {

      private static final String REST_PATH = "{project}/global/networks/{network}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern NETWORK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified network resource.
       *
       * Create a request for the method "networks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param network Name of the network resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String network) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Network.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.network = com.google.api.client.util.Preconditions.checkNotNull(network, "Required parameter network must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the network resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String network;

      /** Name of the network resource to return.
       */
      public java.lang.String getNetwork() {
        return network;
      }

      /** Name of the network resource to return. */
      public Get setNetwork(java.lang.String network) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NETWORK_PATTERN.matcher(network).matches(),
              "Parameter network must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.network = network;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a network resource in the specified project using the data included in the request.
     *
     * Create a request for the method "networks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Network}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Network content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a network resource in the specified project using the data included in the request.
       *
       * Create a request for the method "networks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Network}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Network content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of network resources available to the specified project.
     *
     * Create a request for the method "networks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.NetworkList> {

      private static final String REST_PATH = "{project}/global/networks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of network resources available to the specified project.
       *
       * Create a request for the method "networks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.NetworkList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Projects.List request = compute.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * Returns the specified project resource.
     *
     * Create a request for the method "projects.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public Get get(java.lang.String project) throws java.io.IOException {
      Get result = new Get(project);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Project> {

      private static final String REST_PATH = "{project}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Returns the specified project resource.
       *
       * Create a request for the method "projects.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected Get(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Project.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Moves a persistent disk from one zone to another.
     *
     * Create a request for the method "projects.moveDisk".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link MoveDisk#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.DiskMoveRequest}
     * @return the request
     */
    public MoveDisk moveDisk(java.lang.String project, com.google.api.services.compute.model.DiskMoveRequest content) throws java.io.IOException {
      MoveDisk result = new MoveDisk(project, content);
      initialize(result);
      return result;
    }

    public class MoveDisk extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/moveDisk";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Moves a persistent disk from one zone to another.
       *
       * Create a request for the method "projects.moveDisk".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link MoveDisk#execute()} method to invoke the remote operation. <p>
       * {@link
       * MoveDisk#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.DiskMoveRequest}
       * @since 1.13
       */
      protected MoveDisk(java.lang.String project, com.google.api.services.compute.model.DiskMoveRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public MoveDisk setAlt(java.lang.String alt) {
        return (MoveDisk) super.setAlt(alt);
      }

      @Override
      public MoveDisk setFields(java.lang.String fields) {
        return (MoveDisk) super.setFields(fields);
      }

      @Override
      public MoveDisk setKey(java.lang.String key) {
        return (MoveDisk) super.setKey(key);
      }

      @Override
      public MoveDisk setOauthToken(java.lang.String oauthToken) {
        return (MoveDisk) super.setOauthToken(oauthToken);
      }

      @Override
      public MoveDisk setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (MoveDisk) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public MoveDisk setQuotaUser(java.lang.String quotaUser) {
        return (MoveDisk) super.setQuotaUser(quotaUser);
      }

      @Override
      public MoveDisk setUserIp(java.lang.String userIp) {
        return (MoveDisk) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public MoveDisk setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public MoveDisk set(String parameterName, Object value) {
        return (MoveDisk) super.set(parameterName, value);
      }
    }
    /**
     * Moves an instance and its attached persistent disks from one zone to another.
     *
     * Create a request for the method "projects.moveInstance".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link MoveInstance#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.InstanceMoveRequest}
     * @return the request
     */
    public MoveInstance moveInstance(java.lang.String project, com.google.api.services.compute.model.InstanceMoveRequest content) throws java.io.IOException {
      MoveInstance result = new MoveInstance(project, content);
      initialize(result);
      return result;
    }

    public class MoveInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/moveInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Moves an instance and its attached persistent disks from one zone to another.
       *
       * Create a request for the method "projects.moveInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link MoveInstance#execute()} method to invoke the remote operation. <p>
       * {@link
       * MoveInstance#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.InstanceMoveRequest}
       * @since 1.13
       */
      protected MoveInstance(java.lang.String project, com.google.api.services.compute.model.InstanceMoveRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public MoveInstance setAlt(java.lang.String alt) {
        return (MoveInstance) super.setAlt(alt);
      }

      @Override
      public MoveInstance setFields(java.lang.String fields) {
        return (MoveInstance) super.setFields(fields);
      }

      @Override
      public MoveInstance setKey(java.lang.String key) {
        return (MoveInstance) super.setKey(key);
      }

      @Override
      public MoveInstance setOauthToken(java.lang.String oauthToken) {
        return (MoveInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public MoveInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (MoveInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public MoveInstance setQuotaUser(java.lang.String quotaUser) {
        return (MoveInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public MoveInstance setUserIp(java.lang.String userIp) {
        return (MoveInstance) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public MoveInstance setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public MoveInstance set(String parameterName, Object value) {
        return (MoveInstance) super.set(parameterName, value);
      }
    }
    /**
     * Sets metadata common to all instances within the specified project using the data included in the
     * request.
     *
     * Create a request for the method "projects.setCommonInstanceMetadata".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Metadata}
     * @return the request
     */
    public SetCommonInstanceMetadata setCommonInstanceMetadata(java.lang.String project, com.google.api.services.compute.model.Metadata content) throws java.io.IOException {
      SetCommonInstanceMetadata result = new SetCommonInstanceMetadata(project, content);
      initialize(result);
      return result;
    }

    public class SetCommonInstanceMetadata extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/setCommonInstanceMetadata";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets metadata common to all instances within the specified project using the data included in
       * the request.
       *
       * Create a request for the method "projects.setCommonInstanceMetadata".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetCommonInstanceMetadata#execute()} method to invoke the remote
       * operation. <p> {@link SetCommonInstanceMetadata#initialize(com.google.api.client.googleapis.ser
       * vices.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Metadata}
       * @since 1.13
       */
      protected SetCommonInstanceMetadata(java.lang.String project, com.google.api.services.compute.model.Metadata content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public SetCommonInstanceMetadata setAlt(java.lang.String alt) {
        return (SetCommonInstanceMetadata) super.setAlt(alt);
      }

      @Override
      public SetCommonInstanceMetadata setFields(java.lang.String fields) {
        return (SetCommonInstanceMetadata) super.setFields(fields);
      }

      @Override
      public SetCommonInstanceMetadata setKey(java.lang.String key) {
        return (SetCommonInstanceMetadata) super.setKey(key);
      }

      @Override
      public SetCommonInstanceMetadata setOauthToken(java.lang.String oauthToken) {
        return (SetCommonInstanceMetadata) super.setOauthToken(oauthToken);
      }

      @Override
      public SetCommonInstanceMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetCommonInstanceMetadata) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetCommonInstanceMetadata setQuotaUser(java.lang.String quotaUser) {
        return (SetCommonInstanceMetadata) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetCommonInstanceMetadata setUserIp(java.lang.String userIp) {
        return (SetCommonInstanceMetadata) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetCommonInstanceMetadata setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public SetCommonInstanceMetadata set(String parameterName, Object value) {
        return (SetCommonInstanceMetadata) super.set(parameterName, value);
      }
    }
    /**
     * Enables the usage export feature and sets the usage export bucket where reports are stored. If
     * you provide an empty request body using this method, the usage export feature will be disabled.
     *
     * Create a request for the method "projects.setUsageExportBucket".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetUsageExportBucket#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.UsageExportLocation}
     * @return the request
     */
    public SetUsageExportBucket setUsageExportBucket(java.lang.String project, com.google.api.services.compute.model.UsageExportLocation content) throws java.io.IOException {
      SetUsageExportBucket result = new SetUsageExportBucket(project, content);
      initialize(result);
      return result;
    }

    public class SetUsageExportBucket extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/setUsageExportBucket";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Enables the usage export feature and sets the usage export bucket where reports are stored. If
       * you provide an empty request body using this method, the usage export feature will be disabled.
       *
       * Create a request for the method "projects.setUsageExportBucket".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetUsageExportBucket#execute()} method to invoke the remote
       * operation. <p> {@link SetUsageExportBucket#initialize(com.google.api.client.googleapis.services
       * .AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.UsageExportLocation}
       * @since 1.13
       */
      protected SetUsageExportBucket(java.lang.String project, com.google.api.services.compute.model.UsageExportLocation content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public SetUsageExportBucket setAlt(java.lang.String alt) {
        return (SetUsageExportBucket) super.setAlt(alt);
      }

      @Override
      public SetUsageExportBucket setFields(java.lang.String fields) {
        return (SetUsageExportBucket) super.setFields(fields);
      }

      @Override
      public SetUsageExportBucket setKey(java.lang.String key) {
        return (SetUsageExportBucket) super.setKey(key);
      }

      @Override
      public SetUsageExportBucket setOauthToken(java.lang.String oauthToken) {
        return (SetUsageExportBucket) super.setOauthToken(oauthToken);
      }

      @Override
      public SetUsageExportBucket setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetUsageExportBucket) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetUsageExportBucket setQuotaUser(java.lang.String quotaUser) {
        return (SetUsageExportBucket) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetUsageExportBucket setUserIp(java.lang.String userIp) {
        return (SetUsageExportBucket) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetUsageExportBucket setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public SetUsageExportBucket set(String parameterName, Object value) {
        return (SetUsageExportBucket) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the RegionOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.RegionOperations.List request = compute.regionOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public RegionOperations regionOperations() {
    return new RegionOperations();
  }

  /**
   * The "regionOperations" collection of methods.
   */
  public class RegionOperations {

    /**
     * Deletes the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, region, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified region-specific operation resource.
     *
     * Create a request for the method "regionOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, region, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified region-specific operation resource.
       *
       * Create a request for the method "regionOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the zone scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified region.
     *
     * Create a request for the method "regionOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/regions/{region}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified region.
       *
       * Create a request for the method "regionOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Regions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Regions.List request = compute.regions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Regions regions() {
    return new Regions();
  }

  /**
   * The "regions" collection of methods.
   */
  public class Regions {

    /**
     * Returns the specified region resource.
     *
     * Create a request for the method "regions.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region) throws java.io.IOException {
      Get result = new Get(project, region);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Region> {

      private static final String REST_PATH = "{project}/regions/{region}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified region resource.
       *
       * Create a request for the method "regions.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Region.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region resource to return.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region resource to return. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of region resources available to the specified project.
     *
     * Create a request for the method "regions.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RegionList> {

      private static final String REST_PATH = "{project}/regions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of region resources available to the specified project.
       *
       * Create a request for the method "regions.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RegionList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Routes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Routes.List request = compute.routes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Routes routes() {
    return new Routes();
  }

  /**
   * The "routes" collection of methods.
   */
  public class Routes {

    /**
     * Deletes the specified route resource.
     *
     * Create a request for the method "routes.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String route) throws java.io.IOException {
      Delete result = new Delete(project, route);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified route resource.
       *
       * Create a request for the method "routes.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String route) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = com.google.api.client.util.Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String route;

      /** Name of the route resource to delete.
       */
      public java.lang.String getRoute() {
        return route;
      }

      /** Name of the route resource to delete. */
      public Delete setRoute(java.lang.String route) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified route resource.
     *
     * Create a request for the method "routes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param route Name of the route resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String route) throws java.io.IOException {
      Get result = new Get(project, route);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Route> {

      private static final String REST_PATH = "{project}/global/routes/{route}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ROUTE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified route resource.
       *
       * Create a request for the method "routes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param route Name of the route resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String route) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Route.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.route = com.google.api.client.util.Preconditions.checkNotNull(route, "Required parameter route must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the route resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String route;

      /** Name of the route resource to return.
       */
      public java.lang.String getRoute() {
        return route;
      }

      /** Name of the route resource to return. */
      public Get setRoute(java.lang.String route) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTE_PATTERN.matcher(route).matches(),
              "Parameter route must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.route = route;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a route resource in the specified project using the data included in the request.
     *
     * Create a request for the method "routes.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.Route}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Route content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a route resource in the specified project using the data included in the request.
       *
       * Create a request for the method "routes.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.Route}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Route content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of route resources available to the specified project.
     *
     * Create a request for the method "routes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.RouteList> {

      private static final String REST_PATH = "{project}/global/routes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of route resources available to the specified project.
       *
       * Create a request for the method "routes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.RouteList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Snapshots collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Snapshots.List request = compute.snapshots().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Snapshots snapshots() {
    return new Snapshots();
  }

  /**
   * The "snapshots" collection of methods.
   */
  public class Snapshots {

    /**
     * Deletes the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String snapshot) throws java.io.IOException {
      Delete result = new Delete(project, snapshot);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String snapshot) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String snapshot;

      /** Name of the persistent disk snapshot resource to delete.
       */
      public java.lang.String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to delete. */
      public Delete setSnapshot(java.lang.String snapshot) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified persistent disk snapshot resource.
     *
     * Create a request for the method "snapshots.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param snapshot Name of the persistent disk snapshot resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String snapshot) throws java.io.IOException {
      Get result = new Get(project, snapshot);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Snapshot> {

      private static final String REST_PATH = "{project}/global/snapshots/{snapshot}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern SNAPSHOT_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified persistent disk snapshot resource.
       *
       * Create a request for the method "snapshots.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param snapshot Name of the persistent disk snapshot resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String snapshot) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Snapshot.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.snapshot = com.google.api.client.util.Preconditions.checkNotNull(snapshot, "Required parameter snapshot must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the persistent disk snapshot resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String snapshot;

      /** Name of the persistent disk snapshot resource to return.
       */
      public java.lang.String getSnapshot() {
        return snapshot;
      }

      /** Name of the persistent disk snapshot resource to return. */
      public Get setSnapshot(java.lang.String snapshot) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(SNAPSHOT_PATTERN.matcher(snapshot).matches(),
              "Parameter snapshot must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.snapshot = snapshot;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of persistent disk snapshot resources contained within the specified project.
     *
     * Create a request for the method "snapshots.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.SnapshotList> {

      private static final String REST_PATH = "{project}/global/snapshots";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of persistent disk snapshot resources contained within the specified
       * project.
       *
       * Create a request for the method "snapshots.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SnapshotList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TargetHttpProxies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetHttpProxies.List request = compute.targetHttpProxies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetHttpProxies targetHttpProxies() {
    return new TargetHttpProxies();
  }

  /**
   * The "targetHttpProxies" collection of methods.
   */
  public class TargetHttpProxies {

    /**
     * Deletes the specified TargetHttpProxy resource.
     *
     * Create a request for the method "targetHttpProxies.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param targetHttpProxy Name of the TargetHttpProxy resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String targetHttpProxy) throws java.io.IOException {
      Delete result = new Delete(project, targetHttpProxy);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/targetHttpProxies/{targetHttpProxy}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern TARGET_HTTP_PROXY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetHttpProxy resource.
       *
       * Create a request for the method "targetHttpProxies.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param targetHttpProxy Name of the TargetHttpProxy resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String targetHttpProxy) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.targetHttpProxy = com.google.api.client.util.Preconditions.checkNotNull(targetHttpProxy, "Required parameter targetHttpProxy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the TargetHttpProxy resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String targetHttpProxy;

      /** Name of the TargetHttpProxy resource to delete.
       */
      public java.lang.String getTargetHttpProxy() {
        return targetHttpProxy;
      }

      /** Name of the TargetHttpProxy resource to delete. */
      public Delete setTargetHttpProxy(java.lang.String targetHttpProxy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetHttpProxy = targetHttpProxy;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified TargetHttpProxy resource.
     *
     * Create a request for the method "targetHttpProxies.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param targetHttpProxy Name of the TargetHttpProxy resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String targetHttpProxy) throws java.io.IOException {
      Get result = new Get(project, targetHttpProxy);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetHttpProxy> {

      private static final String REST_PATH = "{project}/global/targetHttpProxies/{targetHttpProxy}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern TARGET_HTTP_PROXY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetHttpProxy resource.
       *
       * Create a request for the method "targetHttpProxies.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param targetHttpProxy Name of the TargetHttpProxy resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String targetHttpProxy) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetHttpProxy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.targetHttpProxy = com.google.api.client.util.Preconditions.checkNotNull(targetHttpProxy, "Required parameter targetHttpProxy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the TargetHttpProxy resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String targetHttpProxy;

      /** Name of the TargetHttpProxy resource to return.
       */
      public java.lang.String getTargetHttpProxy() {
        return targetHttpProxy;
      }

      /** Name of the TargetHttpProxy resource to return. */
      public Get setTargetHttpProxy(java.lang.String targetHttpProxy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetHttpProxy = targetHttpProxy;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a TargetHttpProxy resource in the specified project using the data included in the
     * request.
     *
     * Create a request for the method "targetHttpProxies.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.TargetHttpProxy}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.TargetHttpProxy content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/targetHttpProxies";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a TargetHttpProxy resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "targetHttpProxies.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.TargetHttpProxy}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.TargetHttpProxy content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of TargetHttpProxy resources available to the specified project.
     *
     * Create a request for the method "targetHttpProxies.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetHttpProxyList> {

      private static final String REST_PATH = "{project}/global/targetHttpProxies";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of TargetHttpProxy resources available to the specified project.
       *
       * Create a request for the method "targetHttpProxies.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetHttpProxyList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Changes the URL map for TargetHttpProxy.
     *
     * Create a request for the method "targetHttpProxies.setUrlMap".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetUrlMap#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param targetHttpProxy Name of the TargetHttpProxy resource whose URL map is to be set.
     * @param content the {@link com.google.api.services.compute.model.UrlMapReference}
     * @return the request
     */
    public SetUrlMap setUrlMap(java.lang.String project, java.lang.String targetHttpProxy, com.google.api.services.compute.model.UrlMapReference content) throws java.io.IOException {
      SetUrlMap result = new SetUrlMap(project, targetHttpProxy, content);
      initialize(result);
      return result;
    }

    public class SetUrlMap extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/targetHttpProxies/{targetHttpProxy}/setUrlMap";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern TARGET_HTTP_PROXY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes the URL map for TargetHttpProxy.
       *
       * Create a request for the method "targetHttpProxies.setUrlMap".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetUrlMap#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetUrlMap#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param targetHttpProxy Name of the TargetHttpProxy resource whose URL map is to be set.
       * @param content the {@link com.google.api.services.compute.model.UrlMapReference}
       * @since 1.13
       */
      protected SetUrlMap(java.lang.String project, java.lang.String targetHttpProxy, com.google.api.services.compute.model.UrlMapReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.targetHttpProxy = com.google.api.client.util.Preconditions.checkNotNull(targetHttpProxy, "Required parameter targetHttpProxy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetUrlMap setAlt(java.lang.String alt) {
        return (SetUrlMap) super.setAlt(alt);
      }

      @Override
      public SetUrlMap setFields(java.lang.String fields) {
        return (SetUrlMap) super.setFields(fields);
      }

      @Override
      public SetUrlMap setKey(java.lang.String key) {
        return (SetUrlMap) super.setKey(key);
      }

      @Override
      public SetUrlMap setOauthToken(java.lang.String oauthToken) {
        return (SetUrlMap) super.setOauthToken(oauthToken);
      }

      @Override
      public SetUrlMap setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetUrlMap) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetUrlMap setQuotaUser(java.lang.String quotaUser) {
        return (SetUrlMap) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetUrlMap setUserIp(java.lang.String userIp) {
        return (SetUrlMap) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetUrlMap setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the TargetHttpProxy resource whose URL map is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String targetHttpProxy;

      /** Name of the TargetHttpProxy resource whose URL map is to be set.
       */
      public java.lang.String getTargetHttpProxy() {
        return targetHttpProxy;
      }

      /** Name of the TargetHttpProxy resource whose URL map is to be set. */
      public SetUrlMap setTargetHttpProxy(java.lang.String targetHttpProxy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(),
              "Parameter targetHttpProxy must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetHttpProxy = targetHttpProxy;
        return this;
      }

      @Override
      public SetUrlMap set(String parameterName, Object value) {
        return (SetUrlMap) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TargetInstances collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetInstances.List request = compute.targetInstances().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetInstances targetInstances() {
    return new TargetInstances();
  }

  /**
   * The "targetInstances" collection of methods.
   */
  public class TargetInstances {

    /**
     * Retrieves the list of target instances grouped by scope.
     *
     * Create a request for the method "targetInstances.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.TargetInstanceAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/targetInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of target instances grouped by scope.
       *
       * Create a request for the method "targetInstances.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetInstanceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified TargetInstance resource.
     *
     * Create a request for the method "targetInstances.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param targetInstance Name of the TargetInstance resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String targetInstance) throws java.io.IOException {
      Delete result = new Delete(project, zone, targetInstance);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetInstance resource.
       *
       * Create a request for the method "targetInstances.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param targetInstance Name of the TargetInstance resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String targetInstance) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetInstance = com.google.api.client.util.Preconditions.checkNotNull(targetInstance, "Required parameter targetInstance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(),
              "Parameter targetInstance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the TargetInstance resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String targetInstance;

      /** Name of the TargetInstance resource to delete.
       */
      public java.lang.String getTargetInstance() {
        return targetInstance;
      }

      /** Name of the TargetInstance resource to delete. */
      public Delete setTargetInstance(java.lang.String targetInstance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(),
              "Parameter targetInstance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetInstance = targetInstance;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified TargetInstance resource.
     *
     * Create a request for the method "targetInstances.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param targetInstance Name of the TargetInstance resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String targetInstance) throws java.io.IOException {
      Get result = new Get(project, zone, targetInstance);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetInstance> {

      private static final String REST_PATH = "{project}/zones/{zone}/targetInstances/{targetInstance}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_INSTANCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetInstance resource.
       *
       * Create a request for the method "targetInstances.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param targetInstance Name of the TargetInstance resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String targetInstance) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetInstance.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetInstance = com.google.api.client.util.Preconditions.checkNotNull(targetInstance, "Required parameter targetInstance must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(),
              "Parameter targetInstance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the TargetInstance resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String targetInstance;

      /** Name of the TargetInstance resource to return.
       */
      public java.lang.String getTargetInstance() {
        return targetInstance;
      }

      /** Name of the TargetInstance resource to return. */
      public Get setTargetInstance(java.lang.String targetInstance) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(),
              "Parameter targetInstance must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetInstance = targetInstance;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a TargetInstance resource in the specified project and zone using the data included in
     * the request.
     *
     * Create a request for the method "targetInstances.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @param content the {@link com.google.api.services.compute.model.TargetInstance}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.TargetInstance content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a TargetInstance resource in the specified project and zone using the data included in
       * the request.
       *
       * Create a request for the method "targetInstances.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @param content the {@link com.google.api.services.compute.model.TargetInstance}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.TargetInstance content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of TargetInstance resources available to the specified project and zone.
     *
     * Create a request for the method "targetInstances.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetInstanceList> {

      private static final String REST_PATH = "{project}/zones/{zone}/targetInstances";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of TargetInstance resources available to the specified project and zone.
       *
       * Create a request for the method "targetInstances.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetInstanceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TargetPools collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetPools.List request = compute.targetPools().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetPools targetPools() {
    return new TargetPools();
  }

  /**
   * The "targetPools" collection of methods.
   */
  public class TargetPools {

    /**
     * Adds health check URL to targetPool.
     *
     * Create a request for the method "targetPools.addHealthCheck".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest}
     * @return the request
     */
    public AddHealthCheck addHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest content) throws java.io.IOException {
      AddHealthCheck result = new AddHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds health check URL to targetPool.
       *
       * Create a request for the method "targetPools.addHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link AddHealthCheck#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest}
       * @since 1.13
       */
      protected AddHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddHealthCheck setAlt(java.lang.String alt) {
        return (AddHealthCheck) super.setAlt(alt);
      }

      @Override
      public AddHealthCheck setFields(java.lang.String fields) {
        return (AddHealthCheck) super.setFields(fields);
      }

      @Override
      public AddHealthCheck setKey(java.lang.String key) {
        return (AddHealthCheck) super.setKey(key);
      }

      @Override
      public AddHealthCheck setOauthToken(java.lang.String oauthToken) {
        return (AddHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public AddHealthCheck setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddHealthCheck setQuotaUser(java.lang.String quotaUser) {
        return (AddHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddHealthCheck setUserIp(java.lang.String userIp) {
        return (AddHealthCheck) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public AddHealthCheck setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddHealthCheck setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be added.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be added. */
      public AddHealthCheck setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public AddHealthCheck set(String parameterName, Object value) {
        return (AddHealthCheck) super.set(parameterName, value);
      }
    }
    /**
     * Adds instance url to targetPool.
     *
     * Create a request for the method "targetPools.addInstance".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddInstanceRequest}
     * @return the request
     */
    public AddInstance addInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddInstanceRequest content) throws java.io.IOException {
      AddInstance result = new AddInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class AddInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/addInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Adds instance url to targetPool.
       *
       * Create a request for the method "targetPools.addInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddInstance#execute()} method to invoke the remote operation. <p>
       * {@link
       * AddInstance#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be added.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsAddInstanceRequest}
       * @since 1.13
       */
      protected AddInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsAddInstanceRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public AddInstance setAlt(java.lang.String alt) {
        return (AddInstance) super.setAlt(alt);
      }

      @Override
      public AddInstance setFields(java.lang.String fields) {
        return (AddInstance) super.setFields(fields);
      }

      @Override
      public AddInstance setKey(java.lang.String key) {
        return (AddInstance) super.setKey(key);
      }

      @Override
      public AddInstance setOauthToken(java.lang.String oauthToken) {
        return (AddInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public AddInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddInstance setQuotaUser(java.lang.String quotaUser) {
        return (AddInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddInstance setUserIp(java.lang.String userIp) {
        return (AddInstance) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public AddInstance setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public AddInstance setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be added.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be added. */
      public AddInstance setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public AddInstance set(String parameterName, Object value) {
        return (AddInstance) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of target pools grouped by scope.
     *
     * Create a request for the method "targetPools.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.TargetPoolAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of target pools grouped by scope.
       *
       * Create a request for the method "targetPools.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String targetPool) throws java.io.IOException {
      Delete result = new Delete(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String targetPool) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to delete.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to delete. */
      public Delete setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified TargetPool resource.
     *
     * Create a request for the method "targetPools.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String targetPool) throws java.io.IOException {
      Get result = new Get(project, region, targetPool);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetPool> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetPool resource.
       *
       * Create a request for the method "targetPools.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String targetPool) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPool.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to return.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to return. */
      public Get setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for each IP for the given instance that is referenced
     * by given TargetPool.
     *
     * Create a request for the method "targetPools.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.InstanceReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.InstanceReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.TargetPoolInstanceHealth> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Gets the most recent health check results for each IP for the given instance that is referenced
       * by given TargetPool.
       *
       * Create a request for the method "targetPools.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.InstanceReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.InstanceReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TargetPoolInstanceHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public GetHealth setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which the queried instance belongs.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which the queried instance belongs. */
      public GetHealth setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Creates a TargetPool resource in the specified project and region using the data included in the
     * request.
     *
     * Create a request for the method "targetPools.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.TargetPool}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetPool content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a TargetPool resource in the specified project and region using the data included in
       * the request.
       *
       * Create a request for the method "targetPools.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.TargetPool}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetPool content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of TargetPool resources available to the specified project and region.
     *
     * Create a request for the method "targetPools.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetPoolList> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of TargetPool resources available to the specified project and region.
       *
       * Create a request for the method "targetPools.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetPoolList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Removes health check URL from targetPool.
     *
     * Create a request for the method "targetPools.removeHealthCheck".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest}
     * @return the request
     */
    public RemoveHealthCheck removeHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest content) throws java.io.IOException {
      RemoveHealthCheck result = new RemoveHealthCheck(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveHealthCheck extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes health check URL from targetPool.
       *
       * Create a request for the method "targetPools.removeHealthCheck".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveHealthCheck#execute()} method to invoke the remote operation.
       * <p> {@link RemoveHealthCheck#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which health_check_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest}
       * @since 1.13
       */
      protected RemoveHealthCheck(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveHealthCheck setAlt(java.lang.String alt) {
        return (RemoveHealthCheck) super.setAlt(alt);
      }

      @Override
      public RemoveHealthCheck setFields(java.lang.String fields) {
        return (RemoveHealthCheck) super.setFields(fields);
      }

      @Override
      public RemoveHealthCheck setKey(java.lang.String key) {
        return (RemoveHealthCheck) super.setKey(key);
      }

      @Override
      public RemoveHealthCheck setOauthToken(java.lang.String oauthToken) {
        return (RemoveHealthCheck) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveHealthCheck setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveHealthCheck) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveHealthCheck setQuotaUser(java.lang.String quotaUser) {
        return (RemoveHealthCheck) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveHealthCheck setUserIp(java.lang.String userIp) {
        return (RemoveHealthCheck) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public RemoveHealthCheck setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveHealthCheck setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which health_check_url is to be removed.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which health_check_url is to be removed. */
      public RemoveHealthCheck setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public RemoveHealthCheck set(String parameterName, Object value) {
        return (RemoveHealthCheck) super.set(parameterName, value);
      }
    }
    /**
     * Removes instance URL from targetPool.
     *
     * Create a request for the method "targetPools.removeInstance".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
     * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest}
     * @return the request
     */
    public RemoveInstance removeInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest content) throws java.io.IOException {
      RemoveInstance result = new RemoveInstance(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class RemoveInstance extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/removeInstance";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Removes instance URL from targetPool.
       *
       * Create a request for the method "targetPools.removeInstance".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveInstance#execute()} method to invoke the remote operation.
       * <p> {@link RemoveInstance#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource to which instance_url is to be removed.
       * @param content the {@link com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest}
       * @since 1.13
       */
      protected RemoveInstance(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public RemoveInstance setAlt(java.lang.String alt) {
        return (RemoveInstance) super.setAlt(alt);
      }

      @Override
      public RemoveInstance setFields(java.lang.String fields) {
        return (RemoveInstance) super.setFields(fields);
      }

      @Override
      public RemoveInstance setKey(java.lang.String key) {
        return (RemoveInstance) super.setKey(key);
      }

      @Override
      public RemoveInstance setOauthToken(java.lang.String oauthToken) {
        return (RemoveInstance) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveInstance setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveInstance) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveInstance setQuotaUser(java.lang.String quotaUser) {
        return (RemoveInstance) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveInstance setUserIp(java.lang.String userIp) {
        return (RemoveInstance) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public RemoveInstance setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public RemoveInstance setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource to which instance_url is to be removed.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource to which instance_url is to be removed. */
      public RemoveInstance setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      @Override
      public RemoveInstance set(String parameterName, Object value) {
        return (RemoveInstance) super.set(parameterName, value);
      }
    }
    /**
     * Changes backup pool configurations.
     *
     * Create a request for the method "targetPools.setBackup".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetBackup#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param region Name of the region scoping this request.
     * @param targetPool Name of the TargetPool resource for which the backup is to be set.
     * @param content the {@link com.google.api.services.compute.model.TargetReference}
     * @return the request
     */
    public SetBackup setBackup(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetReference content) throws java.io.IOException {
      SetBackup result = new SetBackup(project, region, targetPool, content);
      initialize(result);
      return result;
    }

    public class SetBackup extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetPools/{targetPool}/setBackup";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_POOL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Changes backup pool configurations.
       *
       * Create a request for the method "targetPools.setBackup".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetBackup#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetBackup#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param region Name of the region scoping this request.
       * @param targetPool Name of the TargetPool resource for which the backup is to be set.
       * @param content the {@link com.google.api.services.compute.model.TargetReference}
       * @since 1.13
       */
      protected SetBackup(java.lang.String project, java.lang.String region, java.lang.String targetPool, com.google.api.services.compute.model.TargetReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = com.google.api.client.util.Preconditions.checkNotNull(targetPool, "Required parameter targetPool must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public SetBackup setAlt(java.lang.String alt) {
        return (SetBackup) super.setAlt(alt);
      }

      @Override
      public SetBackup setFields(java.lang.String fields) {
        return (SetBackup) super.setFields(fields);
      }

      @Override
      public SetBackup setKey(java.lang.String key) {
        return (SetBackup) super.setKey(key);
      }

      @Override
      public SetBackup setOauthToken(java.lang.String oauthToken) {
        return (SetBackup) super.setOauthToken(oauthToken);
      }

      @Override
      public SetBackup setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetBackup) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetBackup setQuotaUser(java.lang.String quotaUser) {
        return (SetBackup) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetBackup setUserIp(java.lang.String userIp) {
        return (SetBackup) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public SetBackup setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public SetBackup setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetPool resource for which the backup is to be set. */
      @com.google.api.client.util.Key
      private java.lang.String targetPool;

      /** Name of the TargetPool resource for which the backup is to be set.
       */
      public java.lang.String getTargetPool() {
        return targetPool;
      }

      /** Name of the TargetPool resource for which the backup is to be set. */
      public SetBackup setTargetPool(java.lang.String targetPool) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_POOL_PATTERN.matcher(targetPool).matches(),
              "Parameter targetPool must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetPool = targetPool;
        return this;
      }

      /** New failoverRatio value for the containing target pool. */
      @com.google.api.client.util.Key
      private java.lang.Float failoverRatio;

      /** New failoverRatio value for the containing target pool.
       */
      public java.lang.Float getFailoverRatio() {
        return failoverRatio;
      }

      /** New failoverRatio value for the containing target pool. */
      public SetBackup setFailoverRatio(java.lang.Float failoverRatio) {
        this.failoverRatio = failoverRatio;
        return this;
      }

      @Override
      public SetBackup set(String parameterName, Object value) {
        return (SetBackup) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the TargetVpnGateways collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.TargetVpnGateways.List request = compute.targetVpnGateways().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public TargetVpnGateways targetVpnGateways() {
    return new TargetVpnGateways();
  }

  /**
   * The "targetVpnGateways" collection of methods.
   */
  public class TargetVpnGateways {

    /**
     * Retrieves the list of target VPN gateways grouped by scope.
     *
     * Create a request for the method "targetVpnGateways.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.TargetVpnGatewayAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/targetVpnGateways";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of target VPN gateways grouped by scope.
       *
       * Create a request for the method "targetVpnGateways.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetVpnGatewayAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified TargetVpnGateway resource.
     *
     * Create a request for the method "targetVpnGateways.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param targetVpnGateway Name of the TargetVpnGateway resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String targetVpnGateway) throws java.io.IOException {
      Delete result = new Delete(project, region, targetVpnGateway);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_VPN_GATEWAY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified TargetVpnGateway resource.
       *
       * Create a request for the method "targetVpnGateways.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param targetVpnGateway Name of the TargetVpnGateway resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String targetVpnGateway) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetVpnGateway = com.google.api.client.util.Preconditions.checkNotNull(targetVpnGateway, "Required parameter targetVpnGateway must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(),
              "Parameter targetVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetVpnGateway resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String targetVpnGateway;

      /** Name of the TargetVpnGateway resource to delete.
       */
      public java.lang.String getTargetVpnGateway() {
        return targetVpnGateway;
      }

      /** Name of the TargetVpnGateway resource to delete. */
      public Delete setTargetVpnGateway(java.lang.String targetVpnGateway) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(),
              "Parameter targetVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetVpnGateway = targetVpnGateway;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified TargetVpnGateway resource.
     *
     * Create a request for the method "targetVpnGateways.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param targetVpnGateway Name of the TargetVpnGateway resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String targetVpnGateway) throws java.io.IOException {
      Get result = new Get(project, region, targetVpnGateway);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.TargetVpnGateway> {

      private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern TARGET_VPN_GATEWAY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified TargetVpnGateway resource.
       *
       * Create a request for the method "targetVpnGateways.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param targetVpnGateway Name of the TargetVpnGateway resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String targetVpnGateway) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetVpnGateway.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetVpnGateway = com.google.api.client.util.Preconditions.checkNotNull(targetVpnGateway, "Required parameter targetVpnGateway must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(),
              "Parameter targetVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the TargetVpnGateway resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String targetVpnGateway;

      /** Name of the TargetVpnGateway resource to return.
       */
      public java.lang.String getTargetVpnGateway() {
        return targetVpnGateway;
      }

      /** Name of the TargetVpnGateway resource to return. */
      public Get setTargetVpnGateway(java.lang.String targetVpnGateway) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(),
              "Parameter targetVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.targetVpnGateway = targetVpnGateway;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a TargetVpnGateway resource in the specified project and region using the data included
     * in the request.
     *
     * Create a request for the method "targetVpnGateways.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.TargetVpnGateway}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetVpnGateway content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a TargetVpnGateway resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "targetVpnGateways.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.TargetVpnGateway}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.TargetVpnGateway content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of TargetVpnGateway resources available to the specified project and region.
     *
     * Create a request for the method "targetVpnGateways.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.TargetVpnGatewayList> {

      private static final String REST_PATH = "{project}/regions/{region}/targetVpnGateways";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of TargetVpnGateway resources available to the specified project and region.
       *
       * Create a request for the method "targetVpnGateways.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.TargetVpnGatewayList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the UrlMaps collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.UrlMaps.List request = compute.urlMaps().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public UrlMaps urlMaps() {
    return new UrlMaps();
  }

  /**
   * The "urlMaps" collection of methods.
   */
  public class UrlMaps {

    /**
     * Deletes the specified UrlMap resource.
     *
     * Create a request for the method "urlMaps.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param urlMap Name of the UrlMap resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String urlMap) throws java.io.IOException {
      Delete result = new Delete(project, urlMap);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern URL_MAP_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified UrlMap resource.
       *
       * Create a request for the method "urlMaps.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param urlMap Name of the UrlMap resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String urlMap) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.urlMap = com.google.api.client.util.Preconditions.checkNotNull(urlMap, "Required parameter urlMap must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the UrlMap resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String urlMap;

      /** Name of the UrlMap resource to delete.
       */
      public java.lang.String getUrlMap() {
        return urlMap;
      }

      /** Name of the UrlMap resource to delete. */
      public Delete setUrlMap(java.lang.String urlMap) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.urlMap = urlMap;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified UrlMap resource.
     *
     * Create a request for the method "urlMaps.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param urlMap Name of the UrlMap resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String urlMap) throws java.io.IOException {
      Get result = new Get(project, urlMap);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.UrlMap> {

      private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern URL_MAP_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified UrlMap resource.
       *
       * Create a request for the method "urlMaps.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param urlMap Name of the UrlMap resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String urlMap) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.UrlMap.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.urlMap = com.google.api.client.util.Preconditions.checkNotNull(urlMap, "Required parameter urlMap must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the UrlMap resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String urlMap;

      /** Name of the UrlMap resource to return.
       */
      public java.lang.String getUrlMap() {
        return urlMap;
      }

      /** Name of the UrlMap resource to return. */
      public Get setUrlMap(java.lang.String urlMap) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.urlMap = urlMap;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a UrlMap resource in the specified project using the data included in the request.
     *
     * Create a request for the method "urlMaps.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param content the {@link com.google.api.services.compute.model.UrlMap}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.UrlMap content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/urlMaps";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a UrlMap resource in the specified project using the data included in the request.
       *
       * Create a request for the method "urlMaps.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param content the {@link com.google.api.services.compute.model.UrlMap}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.UrlMap content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of UrlMap resources available to the specified project.
     *
     * Create a request for the method "urlMaps.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.UrlMapList> {

      private static final String REST_PATH = "{project}/global/urlMaps";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of UrlMap resources available to the specified project.
       *
       * Create a request for the method "urlMaps.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.UrlMapList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Update the entire content of the UrlMap resource. This method supports patch semantics.
     *
     * Create a request for the method "urlMaps.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param urlMap Name of the UrlMap resource to update.
     * @param content the {@link com.google.api.services.compute.model.UrlMap}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMap content) throws java.io.IOException {
      Patch result = new Patch(project, urlMap, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern URL_MAP_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Update the entire content of the UrlMap resource. This method supports patch semantics.
       *
       * Create a request for the method "urlMaps.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param urlMap Name of the UrlMap resource to update.
       * @param content the {@link com.google.api.services.compute.model.UrlMap}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMap content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.urlMap = com.google.api.client.util.Preconditions.checkNotNull(urlMap, "Required parameter urlMap must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the UrlMap resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String urlMap;

      /** Name of the UrlMap resource to update.
       */
      public java.lang.String getUrlMap() {
        return urlMap;
      }

      /** Name of the UrlMap resource to update. */
      public Patch setUrlMap(java.lang.String urlMap) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.urlMap = urlMap;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Update the entire content of the UrlMap resource.
     *
     * Create a request for the method "urlMaps.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param urlMap Name of the UrlMap resource to update.
     * @param content the {@link com.google.api.services.compute.model.UrlMap}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMap content) throws java.io.IOException {
      Update result = new Update(project, urlMap, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern URL_MAP_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Update the entire content of the UrlMap resource.
       *
       * Create a request for the method "urlMaps.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param urlMap Name of the UrlMap resource to update.
       * @param content the {@link com.google.api.services.compute.model.UrlMap}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMap content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.urlMap = com.google.api.client.util.Preconditions.checkNotNull(urlMap, "Required parameter urlMap must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the UrlMap resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String urlMap;

      /** Name of the UrlMap resource to update.
       */
      public java.lang.String getUrlMap() {
        return urlMap;
      }

      /** Name of the UrlMap resource to update. */
      public Update setUrlMap(java.lang.String urlMap) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.urlMap = urlMap;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Run static validation for the UrlMap. In particular, the tests of the provided UrlMap will be
     * run. Calling this method does NOT create the UrlMap.
     *
     * Create a request for the method "urlMaps.validate".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Validate#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @param urlMap Name of the UrlMap resource to be validated as.
     * @param content the {@link com.google.api.services.compute.model.UrlMapsValidateRequest}
     * @return the request
     */
    public Validate validate(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMapsValidateRequest content) throws java.io.IOException {
      Validate result = new Validate(project, urlMap, content);
      initialize(result);
      return result;
    }

    public class Validate extends ComputeRequest<com.google.api.services.compute.model.UrlMapsValidateResponse> {

      private static final String REST_PATH = "{project}/global/urlMaps/{urlMap}/validate";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern URL_MAP_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Run static validation for the UrlMap. In particular, the tests of the provided UrlMap will be
       * run. Calling this method does NOT create the UrlMap.
       *
       * Create a request for the method "urlMaps.validate".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Validate#execute()} method to invoke the remote operation. <p>
       * {@link
       * Validate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @param urlMap Name of the UrlMap resource to be validated as.
       * @param content the {@link com.google.api.services.compute.model.UrlMapsValidateRequest}
       * @since 1.13
       */
      protected Validate(java.lang.String project, java.lang.String urlMap, com.google.api.services.compute.model.UrlMapsValidateRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.UrlMapsValidateResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.urlMap = com.google.api.client.util.Preconditions.checkNotNull(urlMap, "Required parameter urlMap must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Validate setAlt(java.lang.String alt) {
        return (Validate) super.setAlt(alt);
      }

      @Override
      public Validate setFields(java.lang.String fields) {
        return (Validate) super.setFields(fields);
      }

      @Override
      public Validate setKey(java.lang.String key) {
        return (Validate) super.setKey(key);
      }

      @Override
      public Validate setOauthToken(java.lang.String oauthToken) {
        return (Validate) super.setOauthToken(oauthToken);
      }

      @Override
      public Validate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Validate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Validate setQuotaUser(java.lang.String quotaUser) {
        return (Validate) super.setQuotaUser(quotaUser);
      }

      @Override
      public Validate setUserIp(java.lang.String userIp) {
        return (Validate) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public Validate setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the UrlMap resource to be validated as. */
      @com.google.api.client.util.Key
      private java.lang.String urlMap;

      /** Name of the UrlMap resource to be validated as.
       */
      public java.lang.String getUrlMap() {
        return urlMap;
      }

      /** Name of the UrlMap resource to be validated as. */
      public Validate setUrlMap(java.lang.String urlMap) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(URL_MAP_PATTERN.matcher(urlMap).matches(),
              "Parameter urlMap must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.urlMap = urlMap;
        return this;
      }

      @Override
      public Validate set(String parameterName, Object value) {
        return (Validate) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the VpnTunnels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.VpnTunnels.List request = compute.vpnTunnels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public VpnTunnels vpnTunnels() {
    return new VpnTunnels();
  }

  /**
   * The "vpnTunnels" collection of methods.
   */
  public class VpnTunnels {

    /**
     * Retrieves the list of VPN tunnels grouped by scope.
     *
     * Create a request for the method "vpnTunnels.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.VpnTunnelAggregatedList> {

      private static final String REST_PATH = "{project}/aggregated/vpnTunnels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of VPN tunnels grouped by scope.
       *
       * Create a request for the method "vpnTunnels.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.VpnTunnelAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified VpnTunnel resource.
     *
     * Create a request for the method "vpnTunnels.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param vpnTunnel Name of the VpnTunnel resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String vpnTunnel) throws java.io.IOException {
      Delete result = new Delete(project, region, vpnTunnel);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels/{vpnTunnel}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern VPN_TUNNEL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified VpnTunnel resource.
       *
       * Create a request for the method "vpnTunnels.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param vpnTunnel Name of the VpnTunnel resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String vpnTunnel) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.vpnTunnel = com.google.api.client.util.Preconditions.checkNotNull(vpnTunnel, "Required parameter vpnTunnel must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(),
              "Parameter vpnTunnel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the VpnTunnel resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String vpnTunnel;

      /** Name of the VpnTunnel resource to delete.
       */
      public java.lang.String getVpnTunnel() {
        return vpnTunnel;
      }

      /** Name of the VpnTunnel resource to delete. */
      public Delete setVpnTunnel(java.lang.String vpnTunnel) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(),
              "Parameter vpnTunnel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.vpnTunnel = vpnTunnel;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified VpnTunnel resource.
     *
     * Create a request for the method "vpnTunnels.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param vpnTunnel Name of the VpnTunnel resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String vpnTunnel) throws java.io.IOException {
      Get result = new Get(project, region, vpnTunnel);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.VpnTunnel> {

      private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels/{vpnTunnel}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern VPN_TUNNEL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified VpnTunnel resource.
       *
       * Create a request for the method "vpnTunnels.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param vpnTunnel Name of the VpnTunnel resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String vpnTunnel) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.VpnTunnel.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.vpnTunnel = com.google.api.client.util.Preconditions.checkNotNull(vpnTunnel, "Required parameter vpnTunnel must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(),
              "Parameter vpnTunnel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the VpnTunnel resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String vpnTunnel;

      /** Name of the VpnTunnel resource to return.
       */
      public java.lang.String getVpnTunnel() {
        return vpnTunnel;
      }

      /** Name of the VpnTunnel resource to return. */
      public Get setVpnTunnel(java.lang.String vpnTunnel) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(),
              "Parameter vpnTunnel must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.vpnTunnel = vpnTunnel;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a VpnTunnel resource in the specified project and region using the data included in the
     * request.
     *
     * Create a request for the method "vpnTunnels.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.VpnTunnel}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.VpnTunnel content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a VpnTunnel resource in the specified project and region using the data included in the
       * request.
       *
       * Create a request for the method "vpnTunnels.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.VpnTunnel}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.VpnTunnel content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of VpnTunnel resources contained in the specified project and region.
     *
     * Create a request for the method "vpnTunnels.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.VpnTunnelList> {

      private static final String REST_PATH = "{project}/regions/{region}/vpnTunnels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of VpnTunnel resources contained in the specified project and region.
       *
       * Create a request for the method "vpnTunnels.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.VpnTunnelList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ZoneOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ZoneOperations.List request = compute.zoneOperations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ZoneOperations zoneOperations() {
    return new ZoneOperations();
  }

  /**
   * The "zoneOperations" collection of methods.
   */
  public class ZoneOperations {

    /**
     * Deletes the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String operation) throws java.io.IOException {
      Delete result = new Delete(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<Void> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String operation) {
        super(Compute.this, "DELETE", REST_PATH, null, Void.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to delete.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to delete. */
      public Delete setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the specified zone-specific operation resource.
     *
     * Create a request for the method "zoneOperations.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone scoping this request.
     * @param operation Name of the operation resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String operation) throws java.io.IOException {
      Get result = new Get(project, zone, operation);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations/{operation}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern OPERATION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the specified zone-specific operation resource.
       *
       * Create a request for the method "zoneOperations.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone scoping this request.
       * @param operation Name of the operation resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String operation) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = com.google.api.client.util.Preconditions.checkNotNull(operation, "Required parameter operation must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the operation resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String operation;

      /** Name of the operation resource to return.
       */
      public java.lang.String getOperation() {
        return operation;
      }

      /** Name of the operation resource to return. */
      public Get setOperation(java.lang.String operation) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(OPERATION_PATTERN.matcher(operation).matches(),
              "Parameter operation must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.operation = operation;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of operation resources contained within the specified zone.
     *
     * Create a request for the method "zoneOperations.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.OperationList> {

      private static final String REST_PATH = "{project}/zones/{zone}/operations";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves the list of operation resources contained within the specified zone.
       *
       * Create a request for the method "zoneOperations.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.OperationList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone scoping this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone scoping this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Zones collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Zones.List request = compute.zones().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Zones zones() {
    return new Zones();
  }

  /**
   * The "zones" collection of methods.
   */
  public class Zones {

    /**
     * Returns the specified zone resource.
     *
     * Create a request for the method "zones.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      Get result = new Get(project, zone);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Zone> {

      private static final String REST_PATH = "{project}/zones/{zone}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified zone resource.
       *
       * Create a request for the method "zones.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Zone.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone resource to return.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone resource to return. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of zone resources available to the specified project.
     *
     * Create a request for the method "zones.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ZoneList> {

      private static final String REST_PATH = "{project}/zones";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of zone resources available to the specified project.
       *
       * Create a request for the method "zones.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ZoneList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Filter expression for filtering listed resources. */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Filter expression for filtering listed resources.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /** Filter expression for filtering listed resources. */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Tag returned by a previous list request when that list was truncated to maxResults. Used to
     continue a previous list request.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Tag returned by a previous list request when that list was truncated to maxResults. Used to
       * continue a previous list request.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Maximum count of results to be returned. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum count of results to be returned. [default: 500] [minimum: 0] [maximum: 500]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum count of results to be returned. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Compute}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
    }

    /** Builds a new instance of {@link Compute}. */
    @Override
    public Compute build() {
      return new Compute(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link ComputeRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setComputeRequestInitializer(
        ComputeRequestInitializer computeRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(computeRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
