/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-02 at 01:43:48 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for VpnTunnel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VpnTunnel extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource. Provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] Detailed status message for the VPN tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detailedStatus;

  /**
   * [Output Only] Unique identifier for the resource. Defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * IKE networks to use when establishing the VPN tunnel with peer VPN gateway. The value should be
   * a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ikeNetworks;

  /**
   * IKE protocol version to use when establishing the VPN tunnel with peer VPN gateway. Acceptable
   * IKE versions are 1 or 2. Default version is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer ikeVersion;

  /**
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * IP address of the peer VPN gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String peerIp;

  /**
   * [Output Only] URL of the region where the VPN tunnel resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Shared secret used to set the secure session between the GCE VPN gateway and the peer VPN
   * gateway.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sharedSecret;

  /**
   * Hash of the shared secret.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sharedSecretHash;

  /**
   * [Output Only] The status of the VPN tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * URL of the VPN gateway to which this VPN tunnel is associated. Provided by the client when the
   * VPN tunnel is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetVpnGateway;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public VpnTunnel setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource. Provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource. Provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public VpnTunnel setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] Detailed status message for the VPN tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetailedStatus() {
    return detailedStatus;
  }

  /**
   * [Output Only] Detailed status message for the VPN tunnel.
   * @param detailedStatus detailedStatus or {@code null} for none
   */
  public VpnTunnel setDetailedStatus(java.lang.String detailedStatus) {
    this.detailedStatus = detailedStatus;
    return this;
  }

  /**
   * [Output Only] Unique identifier for the resource. Defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] Unique identifier for the resource. Defined by the server.
   * @param id id or {@code null} for none
   */
  public VpnTunnel setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * IKE networks to use when establishing the VPN tunnel with peer VPN gateway. The value should be
   * a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getIkeNetworks() {
    return ikeNetworks;
  }

  /**
   * IKE networks to use when establishing the VPN tunnel with peer VPN gateway. The value should be
   * a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint.
   * @param ikeNetworks ikeNetworks or {@code null} for none
   */
  public VpnTunnel setIkeNetworks(java.util.List<java.lang.String> ikeNetworks) {
    this.ikeNetworks = ikeNetworks;
    return this;
  }

  /**
   * IKE protocol version to use when establishing the VPN tunnel with peer VPN gateway. Acceptable
   * IKE versions are 1 or 2. Default version is 2.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIkeVersion() {
    return ikeVersion;
  }

  /**
   * IKE protocol version to use when establishing the VPN tunnel with peer VPN gateway. Acceptable
   * IKE versions are 1 or 2. Default version is 2.
   * @param ikeVersion ikeVersion or {@code null} for none
   */
  public VpnTunnel setIkeVersion(java.lang.Integer ikeVersion) {
    this.ikeVersion = ikeVersion;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
   * @param kind kind or {@code null} for none
   */
  public VpnTunnel setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public VpnTunnel setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * IP address of the peer VPN gateway.
   * @return value or {@code null} for none
   */
  public java.lang.String getPeerIp() {
    return peerIp;
  }

  /**
   * IP address of the peer VPN gateway.
   * @param peerIp peerIp or {@code null} for none
   */
  public VpnTunnel setPeerIp(java.lang.String peerIp) {
    this.peerIp = peerIp;
    return this;
  }

  /**
   * [Output Only] URL of the region where the VPN tunnel resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the VPN tunnel resides.
   * @param region region or {@code null} for none
   */
  public VpnTunnel setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public VpnTunnel setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Shared secret used to set the secure session between the GCE VPN gateway and the peer VPN
   * gateway.
   * @return value or {@code null} for none
   */
  public java.lang.String getSharedSecret() {
    return sharedSecret;
  }

  /**
   * Shared secret used to set the secure session between the GCE VPN gateway and the peer VPN
   * gateway.
   * @param sharedSecret sharedSecret or {@code null} for none
   */
  public VpnTunnel setSharedSecret(java.lang.String sharedSecret) {
    this.sharedSecret = sharedSecret;
    return this;
  }

  /**
   * Hash of the shared secret.
   * @return value or {@code null} for none
   */
  public java.lang.String getSharedSecretHash() {
    return sharedSecretHash;
  }

  /**
   * Hash of the shared secret.
   * @param sharedSecretHash sharedSecretHash or {@code null} for none
   */
  public VpnTunnel setSharedSecretHash(java.lang.String sharedSecretHash) {
    this.sharedSecretHash = sharedSecretHash;
    return this;
  }

  /**
   * [Output Only] The status of the VPN tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of the VPN tunnel.
   * @param status status or {@code null} for none
   */
  public VpnTunnel setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * URL of the VPN gateway to which this VPN tunnel is associated. Provided by the client when the
   * VPN tunnel is created.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetVpnGateway() {
    return targetVpnGateway;
  }

  /**
   * URL of the VPN gateway to which this VPN tunnel is associated. Provided by the client when the
   * VPN tunnel is created.
   * @param targetVpnGateway targetVpnGateway or {@code null} for none
   */
  public VpnTunnel setTargetVpnGateway(java.lang.String targetVpnGateway) {
    this.targetVpnGateway = targetVpnGateway;
    return this;
  }

  @Override
  public VpnTunnel set(String fieldName, Object value) {
    return (VpnTunnel) super.set(fieldName, value);
  }

  @Override
  public VpnTunnel clone() {
    return (VpnTunnel) super.clone();
  }

}
