/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-06-23 at 00:00:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An HttpHealthCheck resource. This resource defines a template for how individual VMs should be
 * checked for health, via HTTP.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpHealthCheck extends com.google.api.client.json.GenericJson {

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer checkIntervalSec;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer healthyThreshold;

  /**
   * The value of the host header in the HTTP health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestPath;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have greater value than checkIntervalSec.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutSec;

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer unhealthyThreshold;

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCheckIntervalSec() {
    return checkIntervalSec;
  }

  /**
   * How often (in seconds) to send a health check. The default value is 5 seconds.
   * @param checkIntervalSec checkIntervalSec or {@code null} for none
   */
  public HttpHealthCheck setCheckIntervalSec(java.lang.Integer checkIntervalSec) {
    this.checkIntervalSec = checkIntervalSec;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public HttpHealthCheck setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public HttpHealthCheck setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHealthyThreshold() {
    return healthyThreshold;
  }

  /**
   * A so-far unhealthy VM will be marked healthy after this many consecutive successes. The default
   * value is 2.
   * @param healthyThreshold healthyThreshold or {@code null} for none
   */
  public HttpHealthCheck setHealthyThreshold(java.lang.Integer healthyThreshold) {
    this.healthyThreshold = healthyThreshold;
    return this;
  }

  /**
   * The value of the host header in the HTTP health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * The value of the host header in the HTTP health check request. If left empty (default value),
   * the public IP on behalf of which this health check is performed will be used.
   * @param host host or {@code null} for none
   */
  public HttpHealthCheck setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * @param id id or {@code null} for none
   */
  public HttpHealthCheck setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * @param kind kind or {@code null} for none
   */
  public HttpHealthCheck setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public HttpHealthCheck setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The TCP port number for the HTTP health check request. The default value is 80.
   * @param port port or {@code null} for none
   */
  public HttpHealthCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestPath() {
    return requestPath;
  }

  /**
   * The request path of the HTTP health check request. The default value is "/".
   * @param requestPath requestPath or {@code null} for none
   */
  public HttpHealthCheck setRequestPath(java.lang.String requestPath) {
    this.requestPath = requestPath;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * @param selfLink selfLink or {@code null} for none
   */
  public HttpHealthCheck setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have greater value than checkIntervalSec.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutSec() {
    return timeoutSec;
  }

  /**
   * How long (in seconds) to wait before claiming failure. The default value is 5 seconds. It is
   * invalid for timeoutSec to have greater value than checkIntervalSec.
   * @param timeoutSec timeoutSec or {@code null} for none
   */
  public HttpHealthCheck setTimeoutSec(java.lang.Integer timeoutSec) {
    this.timeoutSec = timeoutSec;
    return this;
  }

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getUnhealthyThreshold() {
    return unhealthyThreshold;
  }

  /**
   * A so-far healthy VM will be marked unhealthy after this many consecutive failures. The default
   * value is 2.
   * @param unhealthyThreshold unhealthyThreshold or {@code null} for none
   */
  public HttpHealthCheck setUnhealthyThreshold(java.lang.Integer unhealthyThreshold) {
    this.unhealthyThreshold = unhealthyThreshold;
    return this;
  }

  @Override
  public HttpHealthCheck set(String fieldName, Object value) {
    return (HttpHealthCheck) super.set(fieldName, value);
  }

  @Override
  public HttpHealthCheck clone() {
    return (HttpHealthCheck) super.clone();
  }

}
