/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-07-01 at 02:10:46 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerAggregatedList.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerAggregatedList extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A unique identifier for this aggregated list of managed instance groups. The
   * server defines this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A map of filtered managed instance group lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, InstanceGroupManagersScopedList> items;

  /**
   * [Output Only] Type of the resource. Always compute#instanceGroupManagerAggregatedList for an
   * aggregated list of managed instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output Only] The URL for this aggregated list of managed instance groups. The server defines
   * this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] A unique identifier for this aggregated list of managed instance groups. The
   * server defines this identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this aggregated list of managed instance groups. The
   * server defines this identifier.
   * @param id id or {@code null} for none
   */
  public InstanceGroupManagerAggregatedList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A map of filtered managed instance group lists.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, InstanceGroupManagersScopedList> getItems() {
    return items;
  }

  /**
   * A map of filtered managed instance group lists.
   * @param items items or {@code null} for none
   */
  public InstanceGroupManagerAggregatedList setItems(java.util.Map<String, InstanceGroupManagersScopedList> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instanceGroupManagerAggregatedList for an
   * aggregated list of managed instance groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instanceGroupManagerAggregatedList for an
   * aggregated list of managed instance groups.
   * @param kind kind or {@code null} for none
   */
  public InstanceGroupManagerAggregatedList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public InstanceGroupManagerAggregatedList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output Only] The URL for this aggregated list of managed instance groups. The server defines
   * this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this aggregated list of managed instance groups. The server defines
   * this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceGroupManagerAggregatedList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InstanceGroupManagerAggregatedList set(String fieldName, Object value) {
    return (InstanceGroupManagerAggregatedList) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerAggregatedList clone() {
    return (InstanceGroupManagerAggregatedList) super.clone();
  }

}
