/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-07-16 18:28:29 UTC)
 * on 2015-07-30 at 22:10:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ManagedInstance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedInstance extends com.google.api.client.json.GenericJson {

  /**
   * The current action that the managed instance group has scheduled for the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String currentAction;

  /**
   * The unique identifier for this resource (empty when instance does not exist).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The URL of the instance (set even though instance does not exist yet).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * The status of the instance (empty when instance does not exist).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceStatus;

  /**
   * Information about the last attempt to create or delete the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ManagedInstanceLastAttempt lastAttempt;

  /**
   * The current action that the managed instance group has scheduled for the instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getCurrentAction() {
    return currentAction;
  }

  /**
   * The current action that the managed instance group has scheduled for the instance.
   * @param currentAction currentAction or {@code null} for none
   */
  public ManagedInstance setCurrentAction(java.lang.String currentAction) {
    this.currentAction = currentAction;
    return this;
  }

  /**
   * The unique identifier for this resource (empty when instance does not exist).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * The unique identifier for this resource (empty when instance does not exist).
   * @param id id or {@code null} for none
   */
  public ManagedInstance setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * The URL of the instance (set even though instance does not exist yet).
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * The URL of the instance (set even though instance does not exist yet).
   * @param instance instance or {@code null} for none
   */
  public ManagedInstance setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * The status of the instance (empty when instance does not exist).
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceStatus() {
    return instanceStatus;
  }

  /**
   * The status of the instance (empty when instance does not exist).
   * @param instanceStatus instanceStatus or {@code null} for none
   */
  public ManagedInstance setInstanceStatus(java.lang.String instanceStatus) {
    this.instanceStatus = instanceStatus;
    return this;
  }

  /**
   * Information about the last attempt to create or delete the instance.
   * @return value or {@code null} for none
   */
  public ManagedInstanceLastAttempt getLastAttempt() {
    return lastAttempt;
  }

  /**
   * Information about the last attempt to create or delete the instance.
   * @param lastAttempt lastAttempt or {@code null} for none
   */
  public ManagedInstance setLastAttempt(ManagedInstanceLastAttempt lastAttempt) {
    this.lastAttempt = lastAttempt;
    return this;
  }

  @Override
  public ManagedInstance set(String fieldName, Object value) {
    return (ManagedInstance) super.set(fieldName, value);
  }

  @Override
  public ManagedInstance clone() {
    return (ManagedInstance) super.clone();
  }

}
