/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-04 at 22:37:34 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagersSetTargetPoolsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagersSetTargetPoolsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when updating the target pool entries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The list of target pool URLs that instances in this managed instance group belong to. When the
   * managed instance group creates new instances, the group automatically adds those instances to
   * the target pools that are specified in this parameter. Changing the value of this parameter
   * does not change the target pools of existing instances in this managed instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> targetPools;

  /**
   * The fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when updating the target pool entries.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * The fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when updating the target pool entries.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * The fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when updating the target pool entries.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public InstanceGroupManagersSetTargetPoolsRequest setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * The fingerprint of the target pools information, which is a hash of the contents. This field is
   * used for optimistic locking when updating the target pool entries.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public InstanceGroupManagersSetTargetPoolsRequest encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The list of target pool URLs that instances in this managed instance group belong to. When the
   * managed instance group creates new instances, the group automatically adds those instances to
   * the target pools that are specified in this parameter. Changing the value of this parameter
   * does not change the target pools of existing instances in this managed instance group.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTargetPools() {
    return targetPools;
  }

  /**
   * The list of target pool URLs that instances in this managed instance group belong to. When the
   * managed instance group creates new instances, the group automatically adds those instances to
   * the target pools that are specified in this parameter. Changing the value of this parameter
   * does not change the target pools of existing instances in this managed instance group.
   * @param targetPools targetPools or {@code null} for none
   */
  public InstanceGroupManagersSetTargetPoolsRequest setTargetPools(java.util.List<java.lang.String> targetPools) {
    this.targetPools = targetPools;
    return this;
  }

  @Override
  public InstanceGroupManagersSetTargetPoolsRequest set(String fieldName, Object value) {
    return (InstanceGroupManagersSetTargetPoolsRequest) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagersSetTargetPoolsRequest clone() {
    return (InstanceGroupManagersSetTargetPoolsRequest) super.clone();
  }

}
