/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-04 at 22:37:07 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupsListInstances.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupsListInstances extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A unique identifier for this list of instance groups. The server defines this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A list of InstanceWithNamedPorts resources, which contains all named ports for the given
   * instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceWithNamedPorts> items;

  static {
    // hack to force ProGuard to consider InstanceWithNamedPorts used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InstanceWithNamedPorts.class);
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for lists
   * of instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output Only] The URL for this list of instance groups. The server defines this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] A unique identifier for this list of instance groups. The server defines this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this list of instance groups. The server defines this
   * identifier.
   * @param id id or {@code null} for none
   */
  public InstanceGroupsListInstances setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A list of InstanceWithNamedPorts resources, which contains all named ports for the given
   * instance.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceWithNamedPorts> getItems() {
    return items;
  }

  /**
   * A list of InstanceWithNamedPorts resources, which contains all named ports for the given
   * instance.
   * @param items items or {@code null} for none
   */
  public InstanceGroupsListInstances setItems(java.util.List<InstanceWithNamedPorts> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for lists
   * of instance groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupsListInstances for lists
   * of instance groups.
   * @param kind kind or {@code null} for none
   */
  public InstanceGroupsListInstances setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public InstanceGroupsListInstances setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output Only] The URL for this list of instance groups. The server defines this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this list of instance groups. The server defines this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceGroupsListInstances setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InstanceGroupsListInstances set(String fieldName, Object value) {
    return (InstanceGroupsListInstances) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupsListInstances clone() {
    return (InstanceGroupsListInstances) super.clone();
  }

}
