/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-08-10 at 22:03:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * A boolean that specifies if instances created from this template can send packets with source
   * IP addresses other than their own or receive packets with destination IP addresses other than
   * their own. If you use these instances as an IP gateway or as the next-hop in a Route resource,
   * specify true. Otherwise, specify false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * An optional text description for the instances that are created from this instance template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * An array of disks that are associated with the instances that are created from this template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  static {
    // hack to force ProGuard to consider AttachedDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AttachedDisk.class);
  }

  /**
   * The machine type to use for instances that are created from this template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * The metadata key/value pairs to assign to instances that are created from this template. These
   * pairs can consist of custom metadata or predefined keys. See Project and instance metadata for
   * more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * An array of network access configurations for this interface. This specifies how this interface
   * is configured to interact with other network services, such as connecting to the internet.
   * Currently, ONE_TO_ONE_NAT is the only supported access configuration. If you do not specify any
   * access configurations, the instances that are created from this template will have no external
   * internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  /**
   * A list of scheduling options for the instances that are created from this template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this template. Use metadata queries to obtain
   * the access tokens for these instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  static {
    // hack to force ProGuard to consider ServiceAccount used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ServiceAccount.class);
  }

  /**
   * A list of tags to apply to the instances that are created from this template. The tags identify
   * valid sources or targets for network firewalls. The setTags method can modify this list of
   * tags. Each tag within the list must comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * A boolean that specifies if instances created from this template can send packets with source
   * IP addresses other than their own or receive packets with destination IP addresses other than
   * their own. If you use these instances as an IP gateway or as the next-hop in a Route resource,
   * specify true. Otherwise, specify false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * A boolean that specifies if instances created from this template can send packets with source
   * IP addresses other than their own or receive packets with destination IP addresses other than
   * their own. If you use these instances as an IP gateway or as the next-hop in a Route resource,
   * specify true. Otherwise, specify false.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public InstanceProperties setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * An optional text description for the instances that are created from this instance template.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional text description for the instances that are created from this instance template.
   * @param description description or {@code null} for none
   */
  public InstanceProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * An array of disks that are associated with the instances that are created from this template.
   * @return value or {@code null} for none
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * An array of disks that are associated with the instances that are created from this template.
   * @param disks disks or {@code null} for none
   */
  public InstanceProperties setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * The machine type to use for instances that are created from this template.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * The machine type to use for instances that are created from this template.
   * @param machineType machineType or {@code null} for none
   */
  public InstanceProperties setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from this template. These
   * pairs can consist of custom metadata or predefined keys. See Project and instance metadata for
   * more information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from this template. These
   * pairs can consist of custom metadata or predefined keys. See Project and instance metadata for
   * more information.
   * @param metadata metadata or {@code null} for none
   */
  public InstanceProperties setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * An array of network access configurations for this interface. This specifies how this interface
   * is configured to interact with other network services, such as connecting to the internet.
   * Currently, ONE_TO_ONE_NAT is the only supported access configuration. If you do not specify any
   * access configurations, the instances that are created from this template will have no external
   * internet access.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * An array of network access configurations for this interface. This specifies how this interface
   * is configured to interact with other network services, such as connecting to the internet.
   * Currently, ONE_TO_ONE_NAT is the only supported access configuration. If you do not specify any
   * access configurations, the instances that are created from this template will have no external
   * internet access.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public InstanceProperties setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * A list of scheduling options for the instances that are created from this template.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * A list of scheduling options for the instances that are created from this template.
   * @param scheduling scheduling or {@code null} for none
   */
  public InstanceProperties setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this template. Use metadata queries to obtain
   * the access tokens for these instances.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this template. Use metadata queries to obtain
   * the access tokens for these instances.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public InstanceProperties setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * A list of tags to apply to the instances that are created from this template. The tags identify
   * valid sources or targets for network firewalls. The setTags method can modify this list of
   * tags. Each tag within the list must comply with RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to apply to the instances that are created from this template. The tags identify
   * valid sources or targets for network firewalls. The setTags method can modify this list of
   * tags. Each tag within the list must comply with RFC1035.
   * @param tags tags or {@code null} for none
   */
  public InstanceProperties setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public InstanceProperties set(String fieldName, Object value) {
    return (InstanceProperties) super.set(fieldName, value);
  }

  @Override
  public InstanceProperties clone() {
    return (InstanceProperties) super.clone();
  }

}
