/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-09-03 at 01:41:43 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An Instance Template resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceTemplate extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional text description for the instance template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplate for instance
   * templates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the instance template. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The instance properties for the instance template resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceProperties properties;

  /**
   * [Output Only] The URL for this instance template. The server defines this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] The creation timestamp for this instance template in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public InstanceTemplate setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional text description for the instance template.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional text description for the instance template.
   * @param description description or {@code null} for none
   */
  public InstanceTemplate setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * @param id id or {@code null} for none
   */
  public InstanceTemplate setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplate for instance
   * templates.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplate for instance
   * templates.
   * @param kind kind or {@code null} for none
   */
  public InstanceTemplate setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the instance template. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the instance template. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * @param name name or {@code null} for none
   */
  public InstanceTemplate setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The instance properties for the instance template resource.
   * @return value or {@code null} for none
   */
  public InstanceProperties getProperties() {
    return properties;
  }

  /**
   * The instance properties for the instance template resource.
   * @param properties properties or {@code null} for none
   */
  public InstanceTemplate setProperties(InstanceProperties properties) {
    this.properties = properties;
    return this;
  }

  /**
   * [Output Only] The URL for this instance template. The server defines this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this instance template. The server defines this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceTemplate setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InstanceTemplate set(String fieldName, Object value) {
    return (InstanceTemplate) super.set(fieldName, value);
  }

  @Override
  public InstanceTemplate clone() {
    return (InstanceTemplate) super.clone();
  }

}
