/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-10-13 at 01:33:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Output Only] A list of managed instance groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerList extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * [Output Only] A list of managed instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceGroupManager> items;

  static {
    // hack to force ProGuard to consider InstanceGroupManager used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InstanceGroupManager.class);
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output Only] The URL for this resource type. The server generates this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @param id id or {@code null} for none
   */
  public InstanceGroupManagerList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] A list of managed instance groups.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceGroupManager> getItems() {
    return items;
  }

  /**
   * [Output Only] A list of managed instance groups.
   * @param items items or {@code null} for none
   */
  public InstanceGroupManagerList setItems(java.util.List<InstanceGroupManager> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups.
   * @param kind kind or {@code null} for none
   */
  public InstanceGroupManagerList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public InstanceGroupManagerList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output Only] The URL for this resource type. The server generates this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this resource type. The server generates this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceGroupManagerList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InstanceGroupManagerList set(String fieldName, Object value) {
    return (InstanceGroupManagerList) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerList clone() {
    return (InstanceGroupManagerList) super.clone();
  }

}
