/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-08-03 17:34:38 UTC)
 * on 2015-10-29 at 23:19:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A list of instance templates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceTemplateList extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * [Output Only] list of InstanceTemplate resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceTemplate> items;

  static {
    // hack to force ProGuard to consider InstanceTemplate used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(InstanceTemplate.class);
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for
   * instance template lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output Only] The URL for this instance template list. The server defines this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this instance template. The server defines this
   * identifier.
   * @param id id or {@code null} for none
   */
  public InstanceTemplateList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] list of InstanceTemplate resources.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceTemplate> getItems() {
    return items;
  }

  /**
   * [Output Only] list of InstanceTemplate resources.
   * @param items items or {@code null} for none
   */
  public InstanceTemplateList setItems(java.util.List<InstanceTemplate> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for
   * instance template lists.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceTemplatesListResponse for
   * instance template lists.
   * @param kind kind or {@code null} for none
   */
  public InstanceTemplateList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output Only] A token that is used to continue a truncated list request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public InstanceTemplateList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output Only] The URL for this instance template list. The server defines this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this instance template list. The server defines this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceTemplateList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public InstanceTemplateList set(String fieldName, Object value) {
    return (InstanceTemplateList) super.set(fieldName, value);
  }

  @Override
  public InstanceTemplateList clone() {
    return (InstanceTemplateList) super.clone();
  }

}
