/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-11-16 19:10:01 UTC)
 * on 2015-12-09 at 23:26:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Custom utilization metric policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicyCustomMetricUtilization extends com.google.api.client.json.GenericJson {

  /**
   * Identifier of the metric. It should be a Cloud Monitoring metric. The metric can not have
   * negative values. The metric should be an utilization metric (increasing number of VMs handling
   * requests x times should reduce average value of the metric roughly x times). For example you
   * could use: compute.googleapis.com/instance/network/received_bytes_count.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * Target value of the metric which Autoscaler should maintain. Must be a positive value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double utilizationTarget;

  /**
   * Defines type in which utilization_target is expressed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String utilizationTargetType;

  /**
   * Identifier of the metric. It should be a Cloud Monitoring metric. The metric can not have
   * negative values. The metric should be an utilization metric (increasing number of VMs handling
   * requests x times should reduce average value of the metric roughly x times). For example you
   * could use: compute.googleapis.com/instance/network/received_bytes_count.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * Identifier of the metric. It should be a Cloud Monitoring metric. The metric can not have
   * negative values. The metric should be an utilization metric (increasing number of VMs handling
   * requests x times should reduce average value of the metric roughly x times). For example you
   * could use: compute.googleapis.com/instance/network/received_bytes_count.
   * @param metric metric or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * Target value of the metric which Autoscaler should maintain. Must be a positive value.
   * @return value or {@code null} for none
   */
  public java.lang.Double getUtilizationTarget() {
    return utilizationTarget;
  }

  /**
   * Target value of the metric which Autoscaler should maintain. Must be a positive value.
   * @param utilizationTarget utilizationTarget or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTarget(java.lang.Double utilizationTarget) {
    this.utilizationTarget = utilizationTarget;
    return this;
  }

  /**
   * Defines type in which utilization_target is expressed.
   * @return value or {@code null} for none
   */
  public java.lang.String getUtilizationTargetType() {
    return utilizationTargetType;
  }

  /**
   * Defines type in which utilization_target is expressed.
   * @param utilizationTargetType utilizationTargetType or {@code null} for none
   */
  public AutoscalingPolicyCustomMetricUtilization setUtilizationTargetType(java.lang.String utilizationTargetType) {
    this.utilizationTargetType = utilizationTargetType;
    return this;
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization set(String fieldName, Object value) {
    return (AutoscalingPolicyCustomMetricUtilization) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicyCustomMetricUtilization clone() {
    return (AutoscalingPolicyCustomMetricUtilization) super.clone();
  }

}
