/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-17 at 06:01:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Cloud Autoscaler policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AutoscalingPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The number of seconds that the Autoscaler should wait between two succeeding changes to the
   * number of virtual machines. You should define an interval that is at least as long as the
   * initialization time of a virtual machine and the time it may take for replica pool to create
   * the virtual machine. The default is 60 seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer coolDownPeriodSec;

  /**
   * TODO(jbartosik): Add support for scaling based on muliple utilization metrics (take max
   * recommendation). Exactly one utilization policy should be provided. Configuration parameters of
   * CPU based autoscaling policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingPolicyCpuUtilization cpuUtilization;

  /**
   * Configuration parameters of autoscaling based on custom metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations;

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization;

  /**
   * The maximum number of replicas that the Autoscaler can scale up to. This field is required for
   * config to be effective. Maximum number of replicas should be not lower than minimal number of
   * replicas. Absolute limit for this value is defined in Autoscaler backend.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxNumReplicas;

  /**
   * The minimum number of replicas that the Autoscaler can scale down to. Can't be less than 0. If
   * not provided Autoscaler will choose default value depending on maximal number of replicas.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minNumReplicas;

  /**
   * The number of seconds that the Autoscaler should wait between two succeeding changes to the
   * number of virtual machines. You should define an interval that is at least as long as the
   * initialization time of a virtual machine and the time it may take for replica pool to create
   * the virtual machine. The default is 60 seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCoolDownPeriodSec() {
    return coolDownPeriodSec;
  }

  /**
   * The number of seconds that the Autoscaler should wait between two succeeding changes to the
   * number of virtual machines. You should define an interval that is at least as long as the
   * initialization time of a virtual machine and the time it may take for replica pool to create
   * the virtual machine. The default is 60 seconds.
   * @param coolDownPeriodSec coolDownPeriodSec or {@code null} for none
   */
  public AutoscalingPolicy setCoolDownPeriodSec(java.lang.Integer coolDownPeriodSec) {
    this.coolDownPeriodSec = coolDownPeriodSec;
    return this;
  }

  /**
   * TODO(jbartosik): Add support for scaling based on muliple utilization metrics (take max
   * recommendation). Exactly one utilization policy should be provided. Configuration parameters of
   * CPU based autoscaling policy.
   * @return value or {@code null} for none
   */
  public AutoscalingPolicyCpuUtilization getCpuUtilization() {
    return cpuUtilization;
  }

  /**
   * TODO(jbartosik): Add support for scaling based on muliple utilization metrics (take max
   * recommendation). Exactly one utilization policy should be provided. Configuration parameters of
   * CPU based autoscaling policy.
   * @param cpuUtilization cpuUtilization or {@code null} for none
   */
  public AutoscalingPolicy setCpuUtilization(AutoscalingPolicyCpuUtilization cpuUtilization) {
    this.cpuUtilization = cpuUtilization;
    return this;
  }

  /**
   * Configuration parameters of autoscaling based on custom metric.
   * @return value or {@code null} for none
   */
  public java.util.List<AutoscalingPolicyCustomMetricUtilization> getCustomMetricUtilizations() {
    return customMetricUtilizations;
  }

  /**
   * Configuration parameters of autoscaling based on custom metric.
   * @param customMetricUtilizations customMetricUtilizations or {@code null} for none
   */
  public AutoscalingPolicy setCustomMetricUtilizations(java.util.List<AutoscalingPolicyCustomMetricUtilization> customMetricUtilizations) {
    this.customMetricUtilizations = customMetricUtilizations;
    return this;
  }

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * @return value or {@code null} for none
   */
  public AutoscalingPolicyLoadBalancingUtilization getLoadBalancingUtilization() {
    return loadBalancingUtilization;
  }

  /**
   * Configuration parameters of autoscaling based on load balancer.
   * @param loadBalancingUtilization loadBalancingUtilization or {@code null} for none
   */
  public AutoscalingPolicy setLoadBalancingUtilization(AutoscalingPolicyLoadBalancingUtilization loadBalancingUtilization) {
    this.loadBalancingUtilization = loadBalancingUtilization;
    return this;
  }

  /**
   * The maximum number of replicas that the Autoscaler can scale up to. This field is required for
   * config to be effective. Maximum number of replicas should be not lower than minimal number of
   * replicas. Absolute limit for this value is defined in Autoscaler backend.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxNumReplicas() {
    return maxNumReplicas;
  }

  /**
   * The maximum number of replicas that the Autoscaler can scale up to. This field is required for
   * config to be effective. Maximum number of replicas should be not lower than minimal number of
   * replicas. Absolute limit for this value is defined in Autoscaler backend.
   * @param maxNumReplicas maxNumReplicas or {@code null} for none
   */
  public AutoscalingPolicy setMaxNumReplicas(java.lang.Integer maxNumReplicas) {
    this.maxNumReplicas = maxNumReplicas;
    return this;
  }

  /**
   * The minimum number of replicas that the Autoscaler can scale down to. Can't be less than 0. If
   * not provided Autoscaler will choose default value depending on maximal number of replicas.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinNumReplicas() {
    return minNumReplicas;
  }

  /**
   * The minimum number of replicas that the Autoscaler can scale down to. Can't be less than 0. If
   * not provided Autoscaler will choose default value depending on maximal number of replicas.
   * @param minNumReplicas minNumReplicas or {@code null} for none
   */
  public AutoscalingPolicy setMinNumReplicas(java.lang.Integer minNumReplicas) {
    this.minNumReplicas = minNumReplicas;
    return this;
  }

  @Override
  public AutoscalingPolicy set(String fieldName, Object value) {
    return (AutoscalingPolicy) super.set(fieldName, value);
  }

  @Override
  public AutoscalingPolicy clone() {
    return (AutoscalingPolicy) super.clone();
  }

}
