/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-02-18 22:11:37 UTC)
 * on 2016-02-29 at 23:18:31 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerActionsSummary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerActionsSummary extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The total number of instances in the managed instance group that are scheduled to
   * be abandoned. Abandoning an instance removes it from the managed instance group without
   * deleting it.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer abandoning;

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * created or are currently being created. If the group fails to create one of these instances, it
   * tries again until it creates the instance successfully.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer creating;

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * deleted or are currently being deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer deleting;

  /**
   * [Output Only] The number of instances in the managed instance group that are running and have
   * no scheduled actions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer none;

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * recreated or are currently being being recreated. Recreating an instance deletes the existing
   * root persistent disk and creates a new disk from the image that is defined in the instance
   * template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer recreating;

  /**
   * [Output Only] The number of instances in the managed instance group that are being reconfigured
   * with properties that do not require a restart or a recreate action. For example, setting or
   * removing target pools for the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer refreshing;

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * restarted or are currently being restarted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer restarting;

  /**
   * [Output Only] The total number of instances in the managed instance group that are scheduled to
   * be abandoned. Abandoning an instance removes it from the managed instance group without
   * deleting it.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAbandoning() {
    return abandoning;
  }

  /**
   * [Output Only] The total number of instances in the managed instance group that are scheduled to
   * be abandoned. Abandoning an instance removes it from the managed instance group without
   * deleting it.
   * @param abandoning abandoning or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setAbandoning(java.lang.Integer abandoning) {
    this.abandoning = abandoning;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * created or are currently being created. If the group fails to create one of these instances, it
   * tries again until it creates the instance successfully.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCreating() {
    return creating;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * created or are currently being created. If the group fails to create one of these instances, it
   * tries again until it creates the instance successfully.
   * @param creating creating or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setCreating(java.lang.Integer creating) {
    this.creating = creating;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * deleted or are currently being deleted.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getDeleting() {
    return deleting;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * deleted or are currently being deleted.
   * @param deleting deleting or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setDeleting(java.lang.Integer deleting) {
    this.deleting = deleting;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are running and have
   * no scheduled actions.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNone() {
    return none;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are running and have
   * no scheduled actions.
   * @param none none or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setNone(java.lang.Integer none) {
    this.none = none;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * recreated or are currently being being recreated. Recreating an instance deletes the existing
   * root persistent disk and creates a new disk from the image that is defined in the instance
   * template.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRecreating() {
    return recreating;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * recreated or are currently being being recreated. Recreating an instance deletes the existing
   * root persistent disk and creates a new disk from the image that is defined in the instance
   * template.
   * @param recreating recreating or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setRecreating(java.lang.Integer recreating) {
    this.recreating = recreating;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are being reconfigured
   * with properties that do not require a restart or a recreate action. For example, setting or
   * removing target pools for the instance.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRefreshing() {
    return refreshing;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are being reconfigured
   * with properties that do not require a restart or a recreate action. For example, setting or
   * removing target pools for the instance.
   * @param refreshing refreshing or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setRefreshing(java.lang.Integer refreshing) {
    this.refreshing = refreshing;
    return this;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * restarted or are currently being restarted.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRestarting() {
    return restarting;
  }

  /**
   * [Output Only] The number of instances in the managed instance group that are scheduled to be
   * restarted or are currently being restarted.
   * @param restarting restarting or {@code null} for none
   */
  public InstanceGroupManagerActionsSummary setRestarting(java.lang.Integer restarting) {
    this.restarting = restarting;
    return this;
  }

  @Override
  public InstanceGroupManagerActionsSummary set(String fieldName, Object value) {
    return (InstanceGroupManagerActionsSummary) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerActionsSummary clone() {
    return (InstanceGroupManagerActionsSummary) super.clone();
  }

}
