/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * An instance-attached disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AttachedDisk extends GenericJson {

  /**
   * Persistent disk only; If true, delete the disk and all its data when the associated instance is
   * deleted. This property defaults to false if not specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Boolean deleteOnTerminate;

  /**
   * Persistent disk only; must be unique within the instance when specified. This represents a
   * unique device name that is reflected into the /dev/ tree of a Linux operating system running
   * within the instance. If not specified, a default will be chosen by the system.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String deviceName;

  /**
   * A zero-based index to assign to this disk, where 0 is reserved for the boot disk. If not
   * specified, the server will choose an appropriate value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Integer index;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The mode in which to attach this disk, either "READ_WRITE" or "READ_ONLY".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String mode;

  /**
   * Persistent disk only; the URL of the persistent disk resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String source;

  /**
   * Type of the disk, either "EPHEMERAL" or "PERSISTENT". Note that persistent disks must be
   * created before you can specify them here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * Persistent disk only; If true, delete the disk and all its data when the associated instance is
   * deleted. This property defaults to false if not specified.
   * The value returned may be {@code null}.
   */
  public Boolean getDeleteOnTerminate() {
    return deleteOnTerminate;
  }

  /**
   * Persistent disk only; If true, delete the disk and all its data when the associated instance is
   * deleted. This property defaults to false if not specified.
   * The value set may be {@code null}.
   */
  public AttachedDisk setDeleteOnTerminate(Boolean deleteOnTerminate) {
    this.deleteOnTerminate = deleteOnTerminate;
    return this;
  }

  /**
   * Persistent disk only; must be unique within the instance when specified. This represents a
   * unique device name that is reflected into the /dev/ tree of a Linux operating system running
   * within the instance. If not specified, a default will be chosen by the system.
   * The value returned may be {@code null}.
   */
  public String getDeviceName() {
    return deviceName;
  }

  /**
   * Persistent disk only; must be unique within the instance when specified. This represents a
   * unique device name that is reflected into the /dev/ tree of a Linux operating system running
   * within the instance. If not specified, a default will be chosen by the system.
   * The value set may be {@code null}.
   */
  public AttachedDisk setDeviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

  /**
   * A zero-based index to assign to this disk, where 0 is reserved for the boot disk. If not
   * specified, the server will choose an appropriate value.
   * The value returned may be {@code null}.
   */
  public Integer getIndex() {
    return index;
  }

  /**
   * A zero-based index to assign to this disk, where 0 is reserved for the boot disk. If not
   * specified, the server will choose an appropriate value.
   * The value set may be {@code null}.
   */
  public AttachedDisk setIndex(Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public AttachedDisk setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The mode in which to attach this disk, either "READ_WRITE" or "READ_ONLY".
   * The value returned may be {@code null}.
   */
  public String getMode() {
    return mode;
  }

  /**
   * The mode in which to attach this disk, either "READ_WRITE" or "READ_ONLY".
   * The value set may be {@code null}.
   */
  public AttachedDisk setMode(String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Persistent disk only; the URL of the persistent disk resource.
   * The value returned may be {@code null}.
   */
  public String getSource() {
    return source;
  }

  /**
   * Persistent disk only; the URL of the persistent disk resource.
   * The value set may be {@code null}.
   */
  public AttachedDisk setSource(String source) {
    this.source = source;
    return this;
  }

  /**
   * Type of the disk, either "EPHEMERAL" or "PERSISTENT". Note that persistent disks must be
   * created before you can specify them here.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * Type of the disk, either "EPHEMERAL" or "PERSISTENT". Note that persistent disks must be
   * created before you can specify them here.
   * The value set may be {@code null}.
   */
  public AttachedDisk setType(String type) {
    this.type = type;
    return this;
  }

}
