/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * A network interface resource attached to an instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkInterface extends GenericJson {

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccessConfig> accessConfigs;

  static {
    // hack to force ProGuard to consider AccessConfig used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AccessConfig.class);
  }

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource, determined by the server; for network devices, these are e.g. eth0, eth1,
   * etc. (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * URL of the network resource attached to this interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String network;

  /**
   * An optional IPV4 internal network address to assign to this instance. If not specified, one
   * will be assigned from the available range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String networkIP;

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value returned may be {@code null}.
   */
  public java.util.List<AccessConfig> getAccessConfigs() {
    return accessConfigs;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value set may be {@code null}.
   */
  public NetworkInterface setAccessConfigs(java.util.List<AccessConfig> accessConfigs) {
    this.accessConfigs = accessConfigs;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public NetworkInterface setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource, determined by the server; for network devices, these are e.g. eth0, eth1,
   * etc. (output only).
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource, determined by the server; for network devices, these are e.g. eth0, eth1,
   * etc. (output only).
   * The value set may be {@code null}.
   */
  public NetworkInterface setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the network resource attached to this interface.
   * The value returned may be {@code null}.
   */
  public String getNetwork() {
    return network;
  }

  /**
   * URL of the network resource attached to this interface.
   * The value set may be {@code null}.
   */
  public NetworkInterface setNetwork(String network) {
    this.network = network;
    return this;
  }

  /**
   * An optional IPV4 internal network address to assign to this instance. If not specified, one
   * will be assigned from the available range.
   * The value returned may be {@code null}.
   */
  public String getNetworkIP() {
    return networkIP;
  }

  /**
   * An optional IPV4 internal network address to assign to this instance. If not specified, one
   * will be assigned from the available range.
   * The value set may be {@code null}.
   */
  public NetworkInterface setNetworkIP(String networkIP) {
    this.networkIP = networkIP;
    return this;
  }

}
