/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * A service account.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceAccount extends GenericJson {

  /**
   * Email address of the service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String email;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The list of scopes to be made available for this service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> scopes;

  /**
   * Email address of the service account.
   * The value returned may be {@code null}.
   */
  public String getEmail() {
    return email;
  }

  /**
   * Email address of the service account.
   * The value set may be {@code null}.
   */
  public ServiceAccount setEmail(String email) {
    this.email = email;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public ServiceAccount setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The list of scopes to be made available for this service account.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getScopes() {
    return scopes;
  }

  /**
   * The list of scopes to be made available for this service account.
   * The value set may be {@code null}.
   */
  public ServiceAccount setScopes(java.util.List<String> scopes) {
    this.scopes = scopes;
    return this;
  }

}
