/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * A metadata key/value entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metadata extends GenericJson {

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Items> items;

  static {
    // hack to force ProGuard to consider Items used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Items.class);
  }

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * The value returned may be {@code null}.
   */
  public java.util.List<Items> getItems() {
    return items;
  }

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * The value set may be {@code null}.
   */
  public Metadata setItems(java.util.List<Items> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Metadata setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Model definition for MetadataItems.
   */
  public static final class Items extends GenericJson {

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String key;

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String value;

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * The value returned may be {@code null}.
     */
    public String getKey() {
      return key;
    }

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * The value set may be {@code null}.
     */
    public Items setKey(String key) {
      this.key = key;
      return this;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * The value returned may be {@code null}.
     */
    public String getValue() {
      return value;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * The value set may be {@code null}.
     */
    public Items setValue(String value) {
      this.value = value;
      return this;
    }

  }

}
