/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.ComputeRequestInitializer;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskList;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FirewallList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.Kernel;
import com.google.api.services.compute.model.KernelList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.OperationList;
import com.google.api.services.compute.model.Project;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.SnapshotList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compute
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "compute/v1beta13/projects/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/compute/v1beta13/projects/";

    public Compute(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Compute(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Disks disks() {
        return new Disks();
    }

    public Firewalls firewalls() {
        return new Firewalls();
    }

    public Images images() {
        return new Images();
    }

    public Instances instances() {
        return new Instances();
    }

    public Kernels kernels() {
        return new Kernels();
    }

    public MachineTypes machineTypes() {
        return new MachineTypes();
    }

    public Networks networks() {
        return new Networks();
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    public Snapshots snapshots() {
        return new Snapshots();
    }

    public Zones zones() {
        return new Zones();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION == 14 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need version 1.14 of google-api-client to run version 1.14.2-beta of the Compute Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Compute.DEFAULT_ROOT_URL, Compute.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Compute build() {
            return new Compute(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setComputeRequestInitializer(ComputeRequestInitializer computeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)computeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Zones {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ZoneList> {
            private static final String REST_PATH = "{project}/zones";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ZoneList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Zone> {
            private static final String REST_PATH = "{project}/zones/{zone}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Zone.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string2).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(string).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Snapshots {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Snapshot snapshot) throws IOException {
            Insert insert = new Insert(string, snapshot);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<SnapshotList> {
            private static final String REST_PATH = "{project}/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, SnapshotList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Snapshot snapshot) {
                super(Compute.this, "POST", REST_PATH, (Object)snapshot, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Snapshot> {
            private static final String REST_PATH = "{project}/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Snapshot.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Get setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string2).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Delete setSnapshot(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(string).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.snapshot = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public SetCommonInstanceMetadata setCommonInstanceMetadata(String string, Metadata metadata) throws IOException {
            SetCommonInstanceMetadata setCommonInstanceMetadata = new SetCommonInstanceMetadata(string, metadata);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)setCommonInstanceMetadata);
            return setCommonInstanceMetadata;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetCommonInstanceMetadata
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/setCommonInstanceMetadata";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected SetCommonInstanceMetadata(String string, Metadata metadata) {
                super(Compute.this, "POST", REST_PATH, (Object)metadata, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public SetCommonInstanceMetadata setAlt(String string) {
                return (SetCommonInstanceMetadata)super.setAlt(string);
            }

            public SetCommonInstanceMetadata setFields(String string) {
                return (SetCommonInstanceMetadata)super.setFields(string);
            }

            public SetCommonInstanceMetadata setKey(String string) {
                return (SetCommonInstanceMetadata)super.setKey(string);
            }

            public SetCommonInstanceMetadata setOauthToken(String string) {
                return (SetCommonInstanceMetadata)super.setOauthToken(string);
            }

            public SetCommonInstanceMetadata setPrettyPrint(Boolean bl) {
                return (SetCommonInstanceMetadata)super.setPrettyPrint(bl);
            }

            public SetCommonInstanceMetadata setQuotaUser(String string) {
                return (SetCommonInstanceMetadata)super.setQuotaUser(string);
            }

            public SetCommonInstanceMetadata setUserIp(String string) {
                return (SetCommonInstanceMetadata)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public SetCommonInstanceMetadata setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public SetCommonInstanceMetadata set(String string, Object object) {
                return (SetCommonInstanceMetadata)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Project> {
            private static final String REST_PATH = "{project}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Get(String string) {
                super(Compute.this, "GET", REST_PATH, null, Project.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "{project}/operations";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "{project}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String operation;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string2).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(string).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Networks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Network network) throws IOException {
            Insert insert = new Insert(string, network);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<NetworkList> {
            private static final String REST_PATH = "{project}/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, NetworkList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/networks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Network network) {
                super(Compute.this, "POST", REST_PATH, (Object)network, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Network> {
            private static final String REST_PATH = "{project}/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Network.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Get setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/networks/{network}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern NETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String network;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.NETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.network = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter network must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string2).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getNetwork() {
                return this.network;
            }

            public Delete setNetwork(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NETWORK_PATTERN.matcher(string).matches(), (Object)"Parameter network must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.network = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class MachineTypes {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<MachineTypeList> {
            private static final String REST_PATH = "{project}/machineTypes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, MachineTypeList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<MachineType> {
            private static final String REST_PATH = "{project}/machineTypes/{machineType}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern MACHINETYPE_PATTERN;
            @Key
            private String project;
            @Key
            private String machineType;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, MachineType.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.MACHINETYPE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.machineType = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter machineType must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINETYPE_PATTERN.matcher(string2).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getMachineType() {
                return this.machineType;
            }

            public Get setMachineType(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.MACHINETYPE_PATTERN.matcher(string).matches(), (Object)"Parameter machineType must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.machineType = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Kernels {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<KernelList> {
            private static final String REST_PATH = "{project}/kernels";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, KernelList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Kernel> {
            private static final String REST_PATH = "{project}/kernels/{kernel}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern KERNEL_PATTERN;
            @Key
            private String project;
            @Key
            private String kernel;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Kernel.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.KERNEL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.kernel = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter kernel must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.KERNEL_PATTERN.matcher(string2).matches(), (Object)"Parameter kernel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getKernel() {
                return this.kernel;
            }

            public Get setKernel(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.KERNEL_PATTERN.matcher(string).matches(), (Object)"Parameter kernel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.kernel = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Instances {
        public AddAccessConfig addAccessConfig(String string, String string2, String string3, AccessConfig accessConfig) throws IOException {
            AddAccessConfig addAccessConfig = new AddAccessConfig(string, string2, string3, accessConfig);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)addAccessConfig);
            return addAccessConfig;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public DeleteAccessConfig deleteAccessConfig(String string, String string2, String string3, String string4) throws IOException {
            DeleteAccessConfig deleteAccessConfig = new DeleteAccessConfig(string, string2, string3, string4);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)deleteAccessConfig);
            return deleteAccessConfig;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public GetSerialPortOutput getSerialPortOutput(String string, String string2) throws IOException {
            GetSerialPortOutput getSerialPortOutput = new GetSerialPortOutput(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)getSerialPortOutput);
            return getSerialPortOutput;
        }

        public Insert insert(String string, Instance instance) throws IOException {
            Insert insert = new Insert(string, instance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<InstanceList> {
            private static final String REST_PATH = "{project}/instances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, InstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/instances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Instance instance) {
                super(Compute.this, "POST", REST_PATH, (Object)instance, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetSerialPortOutput
        extends ComputeRequest<SerialPortOutput> {
            private static final String REST_PATH = "{project}/instances/{instance}/serialPort";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String instance;

            protected GetSerialPortOutput(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, SerialPortOutput.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string2).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSerialPortOutput setAlt(String string) {
                return (GetSerialPortOutput)super.setAlt(string);
            }

            public GetSerialPortOutput setFields(String string) {
                return (GetSerialPortOutput)super.setFields(string);
            }

            public GetSerialPortOutput setKey(String string) {
                return (GetSerialPortOutput)super.setKey(string);
            }

            public GetSerialPortOutput setOauthToken(String string) {
                return (GetSerialPortOutput)super.setOauthToken(string);
            }

            public GetSerialPortOutput setPrettyPrint(Boolean bl) {
                return (GetSerialPortOutput)super.setPrettyPrint(bl);
            }

            public GetSerialPortOutput setQuotaUser(String string) {
                return (GetSerialPortOutput)super.setQuotaUser(string);
            }

            public GetSerialPortOutput setUserIp(String string) {
                return (GetSerialPortOutput)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public GetSerialPortOutput setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public GetSerialPortOutput setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public GetSerialPortOutput set(String string, Object object) {
                return (GetSerialPortOutput)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Instance> {
            private static final String REST_PATH = "{project}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String instance;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Instance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string2).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Get setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class DeleteAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/instances/{instance}/deleteAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String instance;
            @Key(value="access_config")
            private String accessConfig;
            @Key(value="network_interface")
            private String networkInterface;

            protected DeleteAccessConfig(String string, String string2, String string3, String string4) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string2).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.accessConfig = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter accessConfig must be specified.");
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string4, (Object)"Required parameter networkInterface must be specified.");
            }

            public DeleteAccessConfig setAlt(String string) {
                return (DeleteAccessConfig)super.setAlt(string);
            }

            public DeleteAccessConfig setFields(String string) {
                return (DeleteAccessConfig)super.setFields(string);
            }

            public DeleteAccessConfig setKey(String string) {
                return (DeleteAccessConfig)super.setKey(string);
            }

            public DeleteAccessConfig setOauthToken(String string) {
                return (DeleteAccessConfig)super.setOauthToken(string);
            }

            public DeleteAccessConfig setPrettyPrint(Boolean bl) {
                return (DeleteAccessConfig)super.setPrettyPrint(bl);
            }

            public DeleteAccessConfig setQuotaUser(String string) {
                return (DeleteAccessConfig)super.setQuotaUser(string);
            }

            public DeleteAccessConfig setUserIp(String string) {
                return (DeleteAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public DeleteAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public DeleteAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getAccessConfig() {
                return this.accessConfig;
            }

            public DeleteAccessConfig setAccessConfig(String string) {
                this.accessConfig = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public DeleteAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public DeleteAccessConfig set(String string, Object object) {
                return (DeleteAccessConfig)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/instances/{instance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String instance;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string2).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public Delete setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AddAccessConfig
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/instances/{instance}/addAccessConfig";
            private final Pattern PROJECT_PATTERN;
            private final Pattern INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String instance;
            @Key(value="network_interface")
            private String networkInterface;

            protected AddAccessConfig(String string, String string2, String string3, AccessConfig accessConfig) {
                super(Compute.this, "POST", REST_PATH, (Object)accessConfig, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.instance = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter instance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string2).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.networkInterface = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter networkInterface must be specified.");
            }

            public AddAccessConfig setAlt(String string) {
                return (AddAccessConfig)super.setAlt(string);
            }

            public AddAccessConfig setFields(String string) {
                return (AddAccessConfig)super.setFields(string);
            }

            public AddAccessConfig setKey(String string) {
                return (AddAccessConfig)super.setKey(string);
            }

            public AddAccessConfig setOauthToken(String string) {
                return (AddAccessConfig)super.setOauthToken(string);
            }

            public AddAccessConfig setPrettyPrint(Boolean bl) {
                return (AddAccessConfig)super.setPrettyPrint(bl);
            }

            public AddAccessConfig setQuotaUser(String string) {
                return (AddAccessConfig)super.setQuotaUser(string);
            }

            public AddAccessConfig setUserIp(String string) {
                return (AddAccessConfig)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public AddAccessConfig setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getInstance() {
                return this.instance;
            }

            public AddAccessConfig setInstance(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.INSTANCE_PATTERN.matcher(string).matches(), (Object)"Parameter instance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.instance = string;
                return this;
            }

            public String getNetworkInterface() {
                return this.networkInterface;
            }

            public AddAccessConfig setNetworkInterface(String string) {
                this.networkInterface = string;
                return this;
            }

            @Override
            public AddAccessConfig set(String string, Object object) {
                return (AddAccessConfig)super.set(string, object);
            }
        }
    }

    public class Images {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Image image) throws IOException {
            Insert insert = new Insert(string, image);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<ImageList> {
            private static final String REST_PATH = "{project}/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, ImageList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/images";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Image image) {
                super(Compute.this, "POST", REST_PATH, (Object)image, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Image> {
            private static final String REST_PATH = "{project}/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Image.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Get setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/images/{image}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern IMAGE_PATTERN;
            @Key
            private String project;
            @Key
            private String image;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.IMAGE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.image = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter image must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string2).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getImage() {
                return this.image;
            }

            public Delete setImage(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.IMAGE_PATTERN.matcher(string).matches(), (Object)"Parameter image must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.image = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Firewalls {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Firewall firewall) throws IOException {
            Insert insert = new Insert(string, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Firewall firewall) throws IOException {
            Patch patch = new Patch(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Firewall firewall) throws IOException {
            Update update = new Update(string, string2, firewall);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Update(String string, String string2, Firewall firewall) {
                super(Compute.this, "PUT", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Update setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Patch(String string, String string2, Firewall firewall) {
                super(Compute.this, "PATCH", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Patch setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<FirewallList> {
            private static final String REST_PATH = "{project}/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, FirewallList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/firewalls";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Firewall firewall) {
                super(Compute.this, "POST", REST_PATH, (Object)firewall, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Firewall> {
            private static final String REST_PATH = "{project}/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Firewall.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Get setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/firewalls/{firewall}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern FIREWALL_PATTERN;
            @Key
            private String project;
            @Key
            private String firewall;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.FIREWALL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.firewall = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter firewall must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string2).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFirewall() {
                return this.firewall;
            }

            public Delete setFirewall(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FIREWALL_PATTERN.matcher(string).matches(), (Object)"Parameter firewall must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.firewall = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Disks {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Disk disk) throws IOException {
            Insert insert = new Insert(string, disk);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ComputeRequest<DiskList> {
            private static final String REST_PATH = "{project}/disks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Long maxResults;

            protected List(String string) {
                super(Compute.this, "GET", REST_PATH, null, DiskList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/disks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Insert(String string, Disk disk) {
                super(Compute.this, "POST", REST_PATH, (Object)disk, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ComputeRequest<Disk> {
            private static final String REST_PATH = "{project}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String disk;

            protected Get(String string, String string2) {
                super(Compute.this, "GET", REST_PATH, null, Disk.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string2).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Get setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "{project}/disks/{disk}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern DISK_PATTERN;
            @Key
            private String project;
            @Key
            private String disk;

            protected Delete(String string, String string2) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.DISK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.disk = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter disk must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string2).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(string).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = string;
                return this;
            }

            public String getDisk() {
                return this.disk;
            }

            public Delete setDisk(String string) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DISK_PATTERN.matcher(string).matches(), (Object)"Parameter disk must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.disk = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }
}

