/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A persistent disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Disk extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Internal use only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String options;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Size of the persistent disk, specified in GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long sizeGb;

  /**
   * The source snapshot used to create this disk. Once the source snapshot has been deleted from
   * the system, this field will be cleared, and will not be set even if a snapshot with the same
   * name has been re-created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sourceSnapshot;

  /**
   * The 'id' value of the snapshot used to create this disk. This value may be used to determine
   * whether the disk was created from the current or a previous instance of a given disk snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sourceSnapshotId;

  /**
   * The status of disk creation (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * URL for the zone where the persistent disk resides; provided by the client when the disk is
   * created. A persistent disk must reside in the same zone as the instance to which it is
   * attached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String zone;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Disk setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Disk setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Disk setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Disk setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Disk setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Internal use only.
   * The value returned may be {@code null}.
   */
  public String getOptions() {
    return options;
  }

  /**
   * Internal use only.
   * The value set may be {@code null}.
   */
  public Disk setOptions(String options) {
    this.options = options;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Disk setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Size of the persistent disk, specified in GB.
   * The value returned may be {@code null}.
   */
  public Long getSizeGb() {
    return sizeGb;
  }

  /**
   * Size of the persistent disk, specified in GB.
   * The value set may be {@code null}.
   */
  public Disk setSizeGb(Long sizeGb) {
    this.sizeGb = sizeGb;
    return this;
  }

  /**
   * The source snapshot used to create this disk. Once the source snapshot has been deleted from
   * the system, this field will be cleared, and will not be set even if a snapshot with the same
   * name has been re-created.
   * The value returned may be {@code null}.
   */
  public String getSourceSnapshot() {
    return sourceSnapshot;
  }

  /**
   * The source snapshot used to create this disk. Once the source snapshot has been deleted from
   * the system, this field will be cleared, and will not be set even if a snapshot with the same
   * name has been re-created.
   * The value set may be {@code null}.
   */
  public Disk setSourceSnapshot(String sourceSnapshot) {
    this.sourceSnapshot = sourceSnapshot;
    return this;
  }

  /**
   * The 'id' value of the snapshot used to create this disk. This value may be used to determine
   * whether the disk was created from the current or a previous instance of a given disk snapshot.
   * The value returned may be {@code null}.
   */
  public String getSourceSnapshotId() {
    return sourceSnapshotId;
  }

  /**
   * The 'id' value of the snapshot used to create this disk. This value may be used to determine
   * whether the disk was created from the current or a previous instance of a given disk snapshot.
   * The value set may be {@code null}.
   */
  public Disk setSourceSnapshotId(String sourceSnapshotId) {
    this.sourceSnapshotId = sourceSnapshotId;
    return this;
  }

  /**
   * The status of disk creation (output only).
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * The status of disk creation (output only).
   * The value set may be {@code null}.
   */
  public Disk setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * URL for the zone where the persistent disk resides; provided by the client when the disk is
   * created. A persistent disk must reside in the same zone as the instance to which it is
   * attached.
   * The value returned may be {@code null}.
   */
  public String getZone() {
    return zone;
  }

  /**
   * URL for the zone where the persistent disk resides; provided by the client when the disk is
   * created. A persistent disk must reside in the same zone as the instance to which it is
   * attached.
   * The value set may be {@code null}.
   */
  public Disk setZone(String zone) {
    this.zone = zone;
    return this;
  }

}
