/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * An instance resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Instance extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  static {
    // hack to force ProGuard to consider AttachedDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AttachedDisk.class);
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * An optional URL of the disk image resource to be to be installed on this instance; provided by
   * the client when the instance is created. If not specified, the server will choose a default
   * image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String image;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String machineType;

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  static {
    // hack to force ProGuard to consider NetworkInterface used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(NetworkInterface.class);
  }

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  static {
    // hack to force ProGuard to consider ServiceAccount used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ServiceAccount.class);
  }

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPED",
   * "TERMINATED", and "STOPPING" (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * An optional, human-readable explanation of the status (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String statusMessage;

  /**
   * An optional set of tags applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client when the instance is created. Each tag must be 1-63
   * characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> tags;

  /**
   * URL of the zone resource describing where this instance should be hosted; provided by the
   * client when the instance is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String zone;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Instance setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Instance setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * The value returned may be {@code null}.
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * The value set may be {@code null}.
   */
  public Instance setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Instance setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * An optional URL of the disk image resource to be to be installed on this instance; provided by
   * the client when the instance is created. If not specified, the server will choose a default
   * image.
   * The value returned may be {@code null}.
   */
  public String getImage() {
    return image;
  }

  /**
   * An optional URL of the disk image resource to be to be installed on this instance; provided by
   * the client when the instance is created. If not specified, the server will choose a default
   * image.
   * The value set may be {@code null}.
   */
  public Instance setImage(String image) {
    this.image = image;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Instance setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * The value returned may be {@code null}.
   */
  public String getMachineType() {
    return machineType;
  }

  /**
   * URL of the machine type resource describing which machine type to use to host the instance;
   * provided by the client when the instance is created.
   * The value set may be {@code null}.
   */
  public Instance setMachineType(String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * The value returned may be {@code null}.
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata key/value pairs assigned to this instance. Consists of custom metadata or predefined
   * keys; see Instance documentation for more information.
   * The value set may be {@code null}.
   */
  public Instance setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Instance setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value returned may be {@code null}.
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * Array of configurations for this interface. This specifies how this interface is configured to
   * interact with other network services, such as connecting to the internet. Currently,
   * ONE_TO_ONE_NAT is the only access config supported. If there are no accessConfigs specified,
   * then this instance will have no external internet access.
   * The value set may be {@code null}.
   */
  public Instance setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Instance setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * The value returned may be {@code null}.
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts each with specified scopes, for which access tokens are to be made
   * available to the instance through metadata queries.
   * The value set may be {@code null}.
   */
  public Instance setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPED",
   * "TERMINATED", and "STOPPING" (output only).
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * Instance status. One of the following values: "PROVISIONING", "STAGING", "RUNNING", "STOPPED",
   * "TERMINATED", and "STOPPING" (output only).
   * The value set may be {@code null}.
   */
  public Instance setStatus(String status) {
    this.status = status;
    return this;
  }

  /**
   * An optional, human-readable explanation of the status (output only).
   * The value returned may be {@code null}.
   */
  public String getStatusMessage() {
    return statusMessage;
  }

  /**
   * An optional, human-readable explanation of the status (output only).
   * The value set may be {@code null}.
   */
  public Instance setStatusMessage(String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * An optional set of tags applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client when the instance is created. Each tag must be 1-63
   * characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getTags() {
    return tags;
  }

  /**
   * An optional set of tags applied to this instance. Used to identify valid sources or targets for
   * network firewalls. Provided by the client when the instance is created. Each tag must be 1-63
   * characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Instance setTags(java.util.List<String> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * URL of the zone resource describing where this instance should be hosted; provided by the
   * client when the instance is created.
   * The value returned may be {@code null}.
   */
  public String getZone() {
    return zone;
  }

  /**
   * URL of the zone resource describing where this instance should be hosted; provided by the
   * client when the instance is created.
   * The value set may be {@code null}.
   */
  public Instance setZone(String zone) {
    this.zone = zone;
    return this;
  }

}
