/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A firewall resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Firewall extends GenericJson {

  /**
   * The list of rules specified by this firewall. Each rule specifies a protocol and port-range
   * tuple that describes a permitted connection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Allowed> allowed;

  static {
    // hack to force ProGuard to consider Allowed used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Allowed.class);
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * URL of the network to which this firewall is applied; provided by the client when the firewall
   * is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String network;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * A list of IP address blocks expressed in CIDR format which this rule applies to. One or both of
   * sourceRanges and sourceTags may be set; an inbound connection is allowed if either the range or
   * the tag of the source matches.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> sourceRanges;

  /**
   * A list of instance tags which this rule applies to. One or both of sourceRanges and sourceTags
   * may be set; an inbound connection is allowed if either the range or the tag of the source
   * matches.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> sourceTags;

  /**
   * A list of instance tags indicating sets of instances located on network which may make network
   * connections as specified in allowed. If no targetTags are specified, the firewall rule applies
   * to all instances on the specified network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> targetTags;

  /**
   * The list of rules specified by this firewall. Each rule specifies a protocol and port-range
   * tuple that describes a permitted connection.
   * The value returned may be {@code null}.
   */
  public java.util.List<Allowed> getAllowed() {
    return allowed;
  }

  /**
   * The list of rules specified by this firewall. Each rule specifies a protocol and port-range
   * tuple that describes a permitted connection.
   * The value set may be {@code null}.
   */
  public Firewall setAllowed(java.util.List<Allowed> allowed) {
    this.allowed = allowed;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Firewall setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Firewall setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Firewall setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Firewall setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Firewall setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the network to which this firewall is applied; provided by the client when the firewall
   * is created.
   * The value returned may be {@code null}.
   */
  public String getNetwork() {
    return network;
  }

  /**
   * URL of the network to which this firewall is applied; provided by the client when the firewall
   * is created.
   * The value set may be {@code null}.
   */
  public Firewall setNetwork(String network) {
    this.network = network;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Firewall setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of IP address blocks expressed in CIDR format which this rule applies to. One or both of
   * sourceRanges and sourceTags may be set; an inbound connection is allowed if either the range or
   * the tag of the source matches.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getSourceRanges() {
    return sourceRanges;
  }

  /**
   * A list of IP address blocks expressed in CIDR format which this rule applies to. One or both of
   * sourceRanges and sourceTags may be set; an inbound connection is allowed if either the range or
   * the tag of the source matches.
   * The value set may be {@code null}.
   */
  public Firewall setSourceRanges(java.util.List<String> sourceRanges) {
    this.sourceRanges = sourceRanges;
    return this;
  }

  /**
   * A list of instance tags which this rule applies to. One or both of sourceRanges and sourceTags
   * may be set; an inbound connection is allowed if either the range or the tag of the source
   * matches.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getSourceTags() {
    return sourceTags;
  }

  /**
   * A list of instance tags which this rule applies to. One or both of sourceRanges and sourceTags
   * may be set; an inbound connection is allowed if either the range or the tag of the source
   * matches.
   * The value set may be {@code null}.
   */
  public Firewall setSourceTags(java.util.List<String> sourceTags) {
    this.sourceTags = sourceTags;
    return this;
  }

  /**
   * A list of instance tags indicating sets of instances located on network which may make network
   * connections as specified in allowed. If no targetTags are specified, the firewall rule applies
   * to all instances on the specified network.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getTargetTags() {
    return targetTags;
  }

  /**
   * A list of instance tags indicating sets of instances located on network which may make network
   * connections as specified in allowed. If no targetTags are specified, the firewall rule applies
   * to all instances on the specified network.
   * The value set may be {@code null}.
   */
  public Firewall setTargetTags(java.util.List<String> targetTags) {
    this.targetTags = targetTags;
    return this;
  }

  /**
   * Model definition for FirewallAllowed.
   */
  public static final class Allowed extends GenericJson {

    /**
     * Required; this is the IP protocol that is allowed for this rule. This can either be a well
     * known protocol string (tcp, udp or icmp) or the IP protocol number.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("IPProtocol")
    private String iPProtocol;

    /**
     * An optional list of ports which are allowed. It is an error to specify this for any protocol
     * that isn't UDP or TCP. Each entry must be either an integer or a range. If not specified,
     * connections through any port are allowed. Example inputs include: ["22"], ["80","443"] and
     * ["12345-12349"].
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<String> ports;

    /**
     * Required; this is the IP protocol that is allowed for this rule. This can either be a well
     * known protocol string (tcp, udp or icmp) or the IP protocol number.
     * The value returned may be {@code null}.
     */
    public String getIPProtocol() {
      return iPProtocol;
    }

    /**
     * Required; this is the IP protocol that is allowed for this rule. This can either be a well
     * known protocol string (tcp, udp or icmp) or the IP protocol number.
     * The value set may be {@code null}.
     */
    public Allowed setIPProtocol(String iPProtocol) {
      this.iPProtocol = iPProtocol;
      return this;
    }

    /**
     * An optional list of ports which are allowed. It is an error to specify this for any protocol
     * that isn't UDP or TCP. Each entry must be either an integer or a range. If not specified,
     * connections through any port are allowed. Example inputs include: ["22"], ["80","443"] and
     * ["12345-12349"].
     * The value returned may be {@code null}.
     */
    public java.util.List<String> getPorts() {
      return ports;
    }

    /**
     * An optional list of ports which are allowed. It is an error to specify this for any protocol
     * that isn't UDP or TCP. Each entry must be either an integer or a range. If not specified,
     * connections through any port are allowed. Example inputs include: ["22"], ["80","443"] and
     * ["12345-12349"].
     * The value set may be {@code null}.
     */
    public Allowed setPorts(java.util.List<String> ports) {
      this.ports = ports;
      return this;
    }

  }

}
