/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * Contains a list of kernel resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class KernelList extends GenericJson {

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * The kernel resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Kernel> items;

  static {
    // hack to force ProGuard to consider Kernel used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(Kernel.class);
  }

  /**
   * Type of resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * A token used to continue a truncated list request (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String nextPageToken;

  /**
   * Server defined URL for this resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public KernelList setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The kernel resources.
   * The value returned may be {@code null}.
   */
  public java.util.List<Kernel> getItems() {
    return items;
  }

  /**
   * The kernel resources.
   * The value set may be {@code null}.
   */
  public KernelList setItems(java.util.List<Kernel> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of resource.
   * The value set may be {@code null}.
   */
  public KernelList setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * The value returned may be {@code null}.
   */
  public String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * A token used to continue a truncated list request (output only).
   * The value set may be {@code null}.
   */
  public KernelList setNextPageToken(String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Server defined URL for this resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for this resource (output only).
   * The value set may be {@code null}.
   */
  public KernelList setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

}
