/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A network resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Network extends GenericJson {

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPv4Range")
  private String iPv4Range;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typically the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String gatewayIPv4;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * The value returned may be {@code null}.
   */
  public String getIPv4Range() {
    return iPv4Range;
  }

  /**
   * Required; The range of internal addresses that are legal on this network. This range is a CIDR
   * specification, for example: 192.168.0.0/16. Provided by the client when the network is created.
   * The value set may be {@code null}.
   */
  public Network setIPv4Range(String iPv4Range) {
    this.iPv4Range = iPv4Range;
    return this;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Network setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Network setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typically the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * The value returned may be {@code null}.
   */
  public String getGatewayIPv4() {
    return gatewayIPv4;
  }

  /**
   * An optional address that is used for default routing to other networks. This must be within the
   * range specified by IPv4Range, and is typically the first usable address in that range. If not
   * specified, the default value is the first usable address in IPv4Range.
   * The value set may be {@code null}.
   */
  public Network setGatewayIPv4(String gatewayIPv4) {
    this.gatewayIPv4 = gatewayIPv4;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Network setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Network setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Network setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Network setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

}
