/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A persistent disk snapshot resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Snapshot extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Size of the persistent disk snapshot, specified in GB (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long diskSizeGb;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The source disk used to create this snapshot. Once the source disk has been deleted from the
   * system, this field will be cleared, and will not be set even if a disk with the same name has
   * been re-created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sourceDisk;

  /**
   * The 'id' value of the disk used to create this snapshot. This value may be used to determine
   * whether the snapshot was taken from the current or a previous instance of a given disk name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sourceDiskId;

  /**
   * The status of the persistent disk snapshot (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String status;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Snapshot setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value set may be {@code null}.
   */
  public Snapshot setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Size of the persistent disk snapshot, specified in GB (output only).
   * The value returned may be {@code null}.
   */
  public Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Size of the persistent disk snapshot, specified in GB (output only).
   * The value set may be {@code null}.
   */
  public Snapshot setDiskSizeGb(Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Snapshot setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Snapshot setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Snapshot setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Snapshot setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The source disk used to create this snapshot. Once the source disk has been deleted from the
   * system, this field will be cleared, and will not be set even if a disk with the same name has
   * been re-created.
   * The value returned may be {@code null}.
   */
  public String getSourceDisk() {
    return sourceDisk;
  }

  /**
   * The source disk used to create this snapshot. Once the source disk has been deleted from the
   * system, this field will be cleared, and will not be set even if a disk with the same name has
   * been re-created.
   * The value set may be {@code null}.
   */
  public Snapshot setSourceDisk(String sourceDisk) {
    this.sourceDisk = sourceDisk;
    return this;
  }

  /**
   * The 'id' value of the disk used to create this snapshot. This value may be used to determine
   * whether the snapshot was taken from the current or a previous instance of a given disk name.
   * The value returned may be {@code null}.
   */
  public String getSourceDiskId() {
    return sourceDiskId;
  }

  /**
   * The 'id' value of the disk used to create this snapshot. This value may be used to determine
   * whether the snapshot was taken from the current or a previous instance of a given disk name.
   * The value set may be {@code null}.
   */
  public Snapshot setSourceDiskId(String sourceDiskId) {
    this.sourceDiskId = sourceDiskId;
    return this;
  }

  /**
   * The status of the persistent disk snapshot (output only).
   * The value returned may be {@code null}.
   */
  public String getStatus() {
    return status;
  }

  /**
   * The status of the persistent disk snapshot (output only).
   * The value set may be {@code null}.
   */
  public Snapshot setStatus(String status) {
    this.status = status;
    return this;
  }

}
