/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * An access configuration attached to an instance's network interface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccessConfig extends GenericJson {

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of this access configuration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String natIP;

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public AccessConfig setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of this access configuration.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of this access configuration.
   * The value set may be {@code null}.
   */
  public AccessConfig setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * The value returned may be {@code null}.
   */
  public String getNatIP() {
    return natIP;
  }

  /**
   * An external IP address associated with this instance. Specify an unused static IP address
   * available to the project. If not specified, the external IP will be drawn from a shared
   * ephemeral pool.
   * The value set may be {@code null}.
   */
  public AccessConfig setNatIP(String natIP) {
    this.natIP = natIP;
    return this;
  }

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * Type of configuration. Must be set to "ONE_TO_ONE_NAT". This configures port-for-port NAT to
   * the internet.
   * The value set may be {@code null}.
   */
  public AccessConfig setType(String type) {
    this.type = type;
    return this;
  }

}
