/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;

/**
 * A quotas entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Quota extends GenericJson {

  /**
   * Quota limit for this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double limit;

  /**
   * Name of the quota metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String metric;

  /**
   * Current usage of this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Double usage;

  /**
   * Quota limit for this metric.
   * The value returned may be {@code null}.
   */
  public Double getLimit() {
    return limit;
  }

  /**
   * Quota limit for this metric.
   * The value set may be {@code null}.
   */
  public Quota setLimit(Double limit) {
    this.limit = limit;
    return this;
  }

  /**
   * Name of the quota metric.
   * The value returned may be {@code null}.
   */
  public String getMetric() {
    return metric;
  }

  /**
   * Name of the quota metric.
   * The value set may be {@code null}.
   */
  public Quota setMetric(String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * Current usage of this metric.
   * The value returned may be {@code null}.
   */
  public Double getUsage() {
    return usage;
  }

  /**
   * Current usage of this metric.
   * The value set may be {@code null}.
   */
  public Quota setUsage(Double usage) {
    this.usage = usage;
    return this;
  }

}
