/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.compute.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.common.primitives.UnsignedLong;

/**
 * A disk image resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Image extends GenericJson {

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String creationTimestamp;

  /**
   * The deprecation status associated with this image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeprecationStatus deprecated;

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private UnsignedLong id;

  /**
   * Type of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String name;

  /**
   * An optional URL of the preferred kernel for use with this disk image. If not specified, a
   * server defined default kernel will be used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String preferredKernel;

  /**
   * The raw disk image parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RawDisk rawDisk;

  /**
   * Server defined URL for the resource (output only).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String sourceType;

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value returned may be {@code null}.
   */
  public String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * Creation timestamp in RFC3339 text format (output only).
   * The value set may be {@code null}.
   */
  public Image setCreationTimestamp(String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * The deprecation status associated with this image.
   * The value returned may be {@code null}.
   */
  public DeprecationStatus getDeprecated() {
    return deprecated;
  }

  /**
   * The deprecation status associated with this image.
   * The value set may be {@code null}.
   */
  public Image setDeprecated(DeprecationStatus deprecated) {
    this.deprecated = deprecated;
    return this;
  }

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Textual description of the resource; provided by the client when the resource is created.
   * The value set may be {@code null}.
   */
  public Image setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value returned may be {@code null}.
   */
  public UnsignedLong getId() {
    return id;
  }

  /**
   * Unique identifier for the resource; defined by the server (output only).
   * The value set may be {@code null}.
   */
  public Image setId(UnsignedLong id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * Type of the resource.
   * The value set may be {@code null}.
   */
  public Image setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value returned may be {@code null}.
   */
  public String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035.
   * The value set may be {@code null}.
   */
  public Image setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * An optional URL of the preferred kernel for use with this disk image. If not specified, a
   * server defined default kernel will be used.
   * The value returned may be {@code null}.
   */
  public String getPreferredKernel() {
    return preferredKernel;
  }

  /**
   * An optional URL of the preferred kernel for use with this disk image. If not specified, a
   * server defined default kernel will be used.
   * The value set may be {@code null}.
   */
  public Image setPreferredKernel(String preferredKernel) {
    this.preferredKernel = preferredKernel;
    return this;
  }

  /**
   * The raw disk image parameters.
   * The value returned may be {@code null}.
   */
  public RawDisk getRawDisk() {
    return rawDisk;
  }

  /**
   * The raw disk image parameters.
   * The value set may be {@code null}.
   */
  public Image setRawDisk(RawDisk rawDisk) {
    this.rawDisk = rawDisk;
    return this;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * Server defined URL for the resource (output only).
   * The value set may be {@code null}.
   */
  public Image setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * The value returned may be {@code null}.
   */
  public String getSourceType() {
    return sourceType;
  }

  /**
   * Must be "RAW"; provided by the client when the disk image is created.
   * The value set may be {@code null}.
   */
  public Image setSourceType(String sourceType) {
    this.sourceType = sourceType;
    return this;
  }

  /**
   * The raw disk image parameters.
   */
  public static final class RawDisk extends GenericJson {

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String containerType;

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String sha1Checksum;

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String source;

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * The value returned may be {@code null}.
     */
    public String getContainerType() {
      return containerType;
    }

    /**
     * The format used to encode and transmit the block device. Should be TAR. This is just a
     * container and transmission format and not a runtime format. Provided by the client when the
     * disk image is created.
     * The value set may be {@code null}.
     */
    public RawDisk setContainerType(String containerType) {
      this.containerType = containerType;
      return this;
    }

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * The value returned may be {@code null}.
     */
    public String getSha1Checksum() {
      return sha1Checksum;
    }

    /**
     * An optional SHA1 checksum of the disk image before unpackaging; provided by the client when the
     * disk image is created.
     * The value set may be {@code null}.
     */
    public RawDisk setSha1Checksum(String sha1Checksum) {
      this.sha1Checksum = sha1Checksum;
      return this;
    }

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * The value returned may be {@code null}.
     */
    public String getSource() {
      return source;
    }

    /**
     * The full Google Cloud Storage URL where the disk image is stored; provided by the client when
     * the disk image is created.
     * The value set may be {@code null}.
     */
    public RawDisk setSource(String source) {
      this.source = source;
      return this;
    }

  }

}
